/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.cache.CacheKeyBuilder;

@SubclassesMustOverrideEqualsAndHashCode
public interface Expr
extends Cacheable {
    public static final String NULL_LITERAL = "null";
    public static final Joiner ARG_JOINER = Joiner.on((String)", ");

    default public boolean isLiteral() {
        return false;
    }

    default public boolean isNullLiteral() {
        return false;
    }

    default public boolean isIdentifier() {
        return false;
    }

    @Nullable
    default public Object getLiteralValue() {
        throw new ISE("Not a literal", new Object[0]);
    }

    @Nullable
    default public IdentifierExpr getIdentifierExprIfIdentifierExpr() {
        return null;
    }

    @Nullable
    default public String getIdentifierIfIdentifier() {
        return null;
    }

    @Nullable
    default public String getBindingIfIdentifier() {
        return null;
    }

    public ExprEval eval(ObjectBinding var1);

    public String stringify();

    public Expr visit(Shuttle var1);

    public BindingAnalysis analyzeInputs();

    @Nullable
    default public ExpressionType getOutputType(InputBindingInspector inspector) {
        return null;
    }

    default public boolean canVectorize(InputBindingInspector inspector) {
        return false;
    }

    default public <T> ExprVectorProcessor<T> buildVectorized(VectorInputBindingInspector inspector) {
        throw Exprs.cannotVectorize(this);
    }

    @Override
    default public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendString(this.stringify()).build();
    }

    public static class BindingAnalysis {
        public static final BindingAnalysis EMTPY = new BindingAnalysis();
        private final ImmutableSet<IdentifierExpr> freeVariables;
        private final ImmutableSet<IdentifierExpr> scalarVariables;
        private final ImmutableSet<IdentifierExpr> arrayVariables;
        private final boolean hasInputArrays;
        private final boolean isOutputArray;

        public BindingAnalysis() {
            this((ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), false, false);
        }

        BindingAnalysis(IdentifierExpr expr) {
            this((ImmutableSet<IdentifierExpr>)ImmutableSet.of((Object)expr), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), (ImmutableSet<IdentifierExpr>)ImmutableSet.of(), false, false);
        }

        private BindingAnalysis(ImmutableSet<IdentifierExpr> freeVariables, ImmutableSet<IdentifierExpr> scalarVariables, ImmutableSet<IdentifierExpr> arrayVariables, boolean hasInputArrays, boolean isOutputArray) {
            this.freeVariables = freeVariables;
            this.scalarVariables = scalarVariables;
            this.arrayVariables = arrayVariables;
            this.hasInputArrays = hasInputArrays;
            this.isOutputArray = isOutputArray;
        }

        public List<String> getRequiredBindingsList() {
            return new ArrayList<String>(this.getRequiredBindings());
        }

        public Set<String> getRequiredBindings() {
            return BindingAnalysis.map(this.freeVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        Set<String> getScalarBindings() {
            return BindingAnalysis.map(this.scalarVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        public Set<String> getArrayBindings() {
            return BindingAnalysis.map(this.arrayVariables, IdentifierExpr::getBindingIfIdentifier);
        }

        public Set<IdentifierExpr> getFreeVariables() {
            return this.freeVariables;
        }

        Set<String> getScalarVariables() {
            return BindingAnalysis.map(this.scalarVariables, IdentifierExpr::getIdentifier);
        }

        Set<String> getArrayVariables() {
            return BindingAnalysis.map(this.arrayVariables, IdentifierExpr::getIdentifier);
        }

        public boolean hasInputArrays() {
            return this.hasInputArrays;
        }

        public boolean isOutputArray() {
            return this.isOutputArray;
        }

        public BindingAnalysis with(Expr other) {
            return this.with(other.analyzeInputs());
        }

        public BindingAnalysis with(BindingAnalysis other) {
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, other.freeVariables)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.scalarVariables, other.scalarVariables)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.arrayVariables, other.arrayVariables)), this.hasInputArrays || other.hasInputArrays, this.isOutputArray || other.isOutputArray);
        }

        public BindingAnalysis withScalarArguments(Set<Expr> scalarArguments) {
            HashSet<IdentifierExpr> moreScalars = new HashSet<IdentifierExpr>();
            for (Expr expr : scalarArguments) {
                boolean isIdentiferExpr = expr.getIdentifierExprIfIdentifierExpr() != null;
                if (!isIdentiferExpr) continue;
                moreScalars.add((IdentifierExpr)expr);
            }
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, moreScalars)), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.scalarVariables, moreScalars)), this.arrayVariables, this.hasInputArrays, this.isOutputArray);
        }

        BindingAnalysis withArrayArguments(Set<Expr> arrayArguments) {
            HashSet<IdentifierExpr> arrayIdentifiers = new HashSet<IdentifierExpr>();
            for (Expr expr : arrayArguments) {
                boolean isIdentifierExpr = expr.getIdentifierExprIfIdentifierExpr() != null;
                if (!isIdentifierExpr) continue;
                arrayIdentifiers.add((IdentifierExpr)expr);
            }
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.freeVariables, arrayIdentifiers)), this.scalarVariables, (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf((Collection)Sets.union(this.arrayVariables, arrayIdentifiers)), this.hasInputArrays || !arrayArguments.isEmpty(), this.isOutputArray);
        }

        BindingAnalysis withArrayInputs(boolean hasArrays) {
            return new BindingAnalysis(this.freeVariables, this.scalarVariables, this.arrayVariables, hasArrays || !this.arrayVariables.isEmpty(), this.isOutputArray);
        }

        BindingAnalysis withArrayOutput(boolean isOutputArray) {
            return new BindingAnalysis(this.freeVariables, this.scalarVariables, this.arrayVariables, this.hasInputArrays, isOutputArray);
        }

        BindingAnalysis removeLambdaArguments(Set<String> lambda) {
            return new BindingAnalysis((ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.freeVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.scalarVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), (ImmutableSet<IdentifierExpr>)ImmutableSet.copyOf(this.arrayVariables.stream().filter(x -> !lambda.contains(x.getIdentifier())).iterator()), this.hasInputArrays, this.isOutputArray);
        }

        private static Set<String> map(Set<IdentifierExpr> variables, Function<IdentifierExpr, String> mapper) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)variables.size());
            for (IdentifierExpr variable : variables) {
                results.add(mapper.apply(variable));
            }
            return results;
        }
    }

    public static interface Shuttle {
        public Expr visit(Expr var1);

        default public List<Expr> visitAll(List<Expr> exprs) {
            ArrayList<Expr> newExprs = new ArrayList<Expr>();
            for (Expr arg : exprs) {
                newExprs.add(arg.visit(this));
            }
            return newExprs;
        }
    }

    public static interface VectorInputBinding
    extends VectorInputBindingInspector {
        public <T> T[] getObjectVector(String var1);

        public long[] getLongVector(String var1);

        public double[] getDoubleVector(String var1);

        @Nullable
        public boolean[] getNullVector(String var1);

        public int getCurrentVectorSize();

        public int getCurrentVectorId();
    }

    public static interface ObjectBinding
    extends InputBindingInspector {
        @Nullable
        public Object get(String var1);
    }

    public static interface VectorInputBindingInspector
    extends InputBindingInspector {
        public int getMaxVectorSize();
    }

    public static interface InputBindingInspector {
        @Nullable
        public ExpressionType getType(String var1);

        default public boolean areNumeric(List<Expr> args) {
            boolean numeric = true;
            for (Expr arg : args) {
                ExpressionType argType = arg.getOutputType(this);
                if (argType == null) continue;
                numeric &= argType.isNumeric();
            }
            return numeric;
        }

        default public boolean areNumeric(Expr ... args) {
            return this.areNumeric(Arrays.asList(args));
        }

        default public boolean areSameTypes(List<Expr> args) {
            ExpressionType currentType = null;
            boolean allSame = true;
            for (Expr arg : args) {
                ExpressionType argType = arg.getOutputType(this);
                if (argType == null) continue;
                if (currentType == null) {
                    currentType = argType;
                }
                allSame &= Objects.equals(argType, currentType);
            }
            return allSame;
        }

        default public boolean areSameTypes(Expr ... args) {
            return this.areSameTypes(Arrays.asList(args));
        }

        default public boolean areScalar(List<Expr> args) {
            boolean scalar = true;
            for (Expr arg : args) {
                ExpressionType argType = arg.getOutputType(this);
                if (argType == null) continue;
                scalar &= argType.isPrimitive();
            }
            return scalar;
        }

        default public boolean areScalar(Expr ... args) {
            return this.areScalar(Arrays.asList(args));
        }

        default public boolean canVectorize(List<Expr> args) {
            boolean canVectorize = true;
            for (Expr arg : args) {
                canVectorize &= arg.canVectorize(this);
            }
            return canVectorize;
        }

        default public boolean canVectorize(Expr ... args) {
            return this.canVectorize(Arrays.asList(args));
        }
    }
}

