/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import org.apache.druid.math.expr.BinaryEvalOpExprBase;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorMathProcessors;

class BinPowExpr
extends BinaryEvalOpExprBase {
    BinPowExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinPowExpr(this.op, left, right);
    }

    @Override
    protected long evalLong(long left, long right) {
        return LongMath.pow((long)left, (int)Ints.checkedCast((long)right));
    }

    @Override
    protected double evalDouble(double left, double right) {
        return Math.pow(left, right);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return inspector.areScalar(this.left, this.right) && inspector.canVectorize(this.left, this.right);
    }

    @Override
    public <T> ExprVectorProcessor<T> buildVectorized(Expr.VectorInputBindingInspector inspector) {
        return VectorMathProcessors.power(inspector, this.left, this.right);
    }
}

