/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.BinaryBooleanOpExprBase;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorComparisonProcessors;

class BinGtExpr
extends BinaryBooleanOpExprBase {
    BinGtExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinGtExpr(this.op, left, right);
    }

    @Override
    protected boolean evalString(@Nullable String left, @Nullable String right) {
        return Comparators.naturalNullsFirst().compare((Object)left, (Object)right) > 0;
    }

    @Override
    protected final boolean evalLong(long left, long right) {
        return left > right;
    }

    @Override
    protected final boolean evalDouble(double left, double right) {
        return Double.compare(left, right) > 0;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return inspector.canVectorize(this.left, this.right);
    }

    @Override
    public <T> ExprVectorProcessor<T> buildVectorized(Expr.VectorInputBindingInspector inspector) {
        return VectorComparisonProcessors.greaterThan(inspector, this.left, this.right);
    }
}

