/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;

public class JvmThreadsMonitor
extends FeedDefiningMonitor {
    private final Map<String, String[]> dimensions;
    private int lastLiveThreads = 0;
    private long lastStartedThreads = 0L;

    public JvmThreadsMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public JvmThreadsMonitor(Map<String, String[]> dimensions, String feed) {
        super(feed);
        Preconditions.checkNotNull(dimensions, (Object)"dimensions");
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        int newLiveThreads = threadBean.getThreadCount();
        long newStartedThreads = threadBean.getTotalStartedThreadCount();
        long startedThreadsDiff = newStartedThreads - this.lastStartedThreads;
        emitter.emit(builder.build("jvm/threads/started", startedThreadsDiff));
        emitter.emit(builder.build("jvm/threads/finished", (long)this.lastLiveThreads + startedThreadsDiff - (long)newLiveThreads));
        emitter.emit(builder.build("jvm/threads/live", newLiveThreads));
        emitter.emit(builder.build("jvm/threads/liveDaemon", threadBean.getDaemonThreadCount()));
        emitter.emit(builder.build("jvm/threads/livePeak", threadBean.getPeakThreadCount()));
        threadBean.resetPeakThreadCount();
        this.lastStartedThreads = newStartedThreads;
        this.lastLiveThreads = newLiveThreads;
        return true;
    }
}

