/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.java.util.metrics.MonitorSchedulerConfig;

public class BasicMonitorScheduler
extends MonitorScheduler {
    private final ScheduledExecutorService exec;

    public BasicMonitorScheduler(MonitorSchedulerConfig config, ServiceEmitter emitter, List<Monitor> monitors, ScheduledExecutorService exec) {
        super(config, emitter, monitors);
        this.exec = exec;
    }

    @Override
    void startMonitor(Monitor monitor) {
        monitor.start();
        ScheduledExecutors.scheduleAtFixedRate(this.exec, this.getConfig().getEmitterPeriod(), () -> {
            if (this.hasMonitor(monitor) && monitor.monitor(this.getEmitter())) {
                return ScheduledExecutors.Signal.REPEAT;
            }
            this.removeMonitor(monitor);
            return ScheduledExecutors.Signal.STOP;
        });
    }
}

