/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.druid.java.util.common.guava.DelegatingYieldingAccumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;

final class LimitedSequence<T>
extends YieldingSequenceBase<T> {
    private final Sequence<T> baseSequence;
    private final long limit;

    LimitedSequence(Sequence<T> baseSequence, long limit) {
        Preconditions.checkNotNull(baseSequence);
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit is negative");
        this.baseSequence = baseSequence;
        this.limit = limit;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        LimitedYieldingAccumulator<OutType> limitedAccumulator = new LimitedYieldingAccumulator<OutType>(accumulator);
        Yielder<OutType> subYielder = this.baseSequence.toYielder(initValue, limitedAccumulator);
        return new LimitedYielder<OutType>(subYielder, limitedAccumulator);
    }

    private class LimitedYieldingAccumulator<OutType>
    extends DelegatingYieldingAccumulator<OutType, T> {
        long count;
        boolean interruptYield;

        LimitedYieldingAccumulator(YieldingAccumulator<OutType, T> accumulator) {
            super(accumulator);
            this.interruptYield = false;
            this.count = 0L;
        }

        @Override
        public OutType accumulate(OutType accumulated, T in) {
            ++this.count;
            if (!this.withinThreshold()) {
                this.interruptYield = true;
            }
            OutType retVal = super.accumulate(accumulated, in);
            if (this.yielded() && this.interruptYield) {
                this.interruptYield = false;
            }
            if (this.interruptYield) {
                this.yield();
            }
            return retVal;
        }

        boolean isInterruptYield() {
            return this.interruptYield;
        }

        private boolean withinThreshold() {
            return this.count < LimitedSequence.this.limit;
        }
    }

    private class LimitedYielder<OutType>
    implements Yielder<OutType> {
        private final Yielder<OutType> subYielder;
        private final LimitedYieldingAccumulator<OutType> limitedAccumulator;

        LimitedYielder(Yielder<OutType> subYielder, LimitedYieldingAccumulator<OutType> limitedAccumulator) {
            this.subYielder = subYielder;
            this.limitedAccumulator = limitedAccumulator;
        }

        @Override
        public OutType get() {
            return this.subYielder.get();
        }

        @Override
        public Yielder<OutType> next(OutType initValue) {
            if (!((LimitedYieldingAccumulator)this.limitedAccumulator).withinThreshold()) {
                return Yielders.done(initValue, this.subYielder);
            }
            Yielder<OutType> next = this.subYielder.next(initValue);
            if (!(((LimitedYieldingAccumulator)this.limitedAccumulator).withinThreshold() || this.limitedAccumulator.yielded() && !this.limitedAccumulator.isInterruptYield())) {
                next = Yielders.done(next.get(), next);
            }
            return new LimitedYielder<OutType>(next, this.limitedAccumulator);
        }

        @Override
        public boolean isDone() {
            return this.subYielder.isDone() || !((LimitedYieldingAccumulator)this.limitedAccumulator).withinThreshold() && (!this.limitedAccumulator.yielded() || this.limitedAccumulator.isInterruptYield());
        }

        @Override
        public void close() throws IOException {
            this.subYielder.close();
        }
    }
}

