/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.chrono.ISOChronology;

public class JodaUtils {
    public static final long MAX_INSTANT = 0x3FFFFFFFFFFFFFFFL;
    public static final long MIN_INSTANT = -4611686018427387904L;

    public static List<Interval> condenseIntervals(Iterable<Interval> intervals) {
        TreeSet<Interval> sortedIntervals;
        if (intervals instanceof SortedSet) {
            sortedIntervals = (TreeSet<Interval>)intervals;
        } else {
            sortedIntervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
            for (Interval interval : intervals) {
                sortedIntervals.add(interval);
            }
        }
        return ImmutableList.copyOf(JodaUtils.condensedIntervalsIterator(sortedIntervals.iterator()));
    }

    public static Iterator<Interval> condensedIntervalsIterator(Iterator<Interval> sortedIntervals) {
        if (sortedIntervals == null || !sortedIntervals.hasNext()) {
            return Collections.emptyIterator();
        }
        final PeekingIterator peekingIterator = Iterators.peekingIterator(sortedIntervals);
        return new Iterator<Interval>(){
            private Interval previous;

            @Override
            public boolean hasNext() {
                return peekingIterator.hasNext();
            }

            @Override
            public Interval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Interval currInterval = (Interval)peekingIterator.next();
                if (currInterval == null) {
                    throw new IAE("Element of intervals is null", new Object[0]);
                }
                JodaUtils.verifyAscendingSortOrder(this.previous, currInterval);
                this.previous = currInterval;
                while (this.hasNext()) {
                    Interval next = (Interval)peekingIterator.peek();
                    if (next == null) {
                        throw new IAE("Element of intervals is null", new Object[0]);
                    }
                    if (currInterval.abuts((ReadableInterval)next)) {
                        currInterval = new Interval((ReadableInstant)currInterval.getStart(), (ReadableInstant)next.getEnd());
                        peekingIterator.next();
                        continue;
                    }
                    if (!currInterval.overlaps((ReadableInterval)next)) break;
                    DateTime nextEnd = next.getEnd();
                    DateTime currEnd = currInterval.getEnd();
                    currInterval = new Interval((ReadableInstant)currInterval.getStart(), (ReadableInstant)(nextEnd.isAfter((ReadableInstant)currEnd) ? nextEnd : currEnd));
                    peekingIterator.next();
                }
                return currInterval;
            }
        };
    }

    public static boolean containOverlappingIntervals(Iterable<Interval> intervals) {
        if (intervals == null) {
            return false;
        }
        boolean retVal = false;
        Interval previous = null;
        for (Interval current : intervals) {
            if (current == null) {
                throw new IAE("Intervals should not contain nulls", new Object[0]);
            }
            JodaUtils.verifyAscendingSortOrder(previous, current);
            if (previous != null && previous.overlaps((ReadableInterval)current)) {
                retVal = true;
                break;
            }
            previous = current;
        }
        return retVal;
    }

    private static void verifyAscendingSortOrder(Interval previous, Interval current) {
        if (previous != null && previous.isAfter((ReadableInterval)current)) {
            throw new IAE("Adjacent intervals are not sorted [%s,%s]", previous, current);
        }
    }

    public static Interval umbrellaInterval(Iterable<Interval> intervals) {
        boolean emptyIntervals = true;
        DateTimeComparator dateTimeComp = DateTimeComparator.getInstance();
        DateTime minStart = new DateTime(Long.MAX_VALUE, (Chronology)ISOChronology.getInstanceUTC());
        DateTime maxEnd = new DateTime(Long.MIN_VALUE, (Chronology)ISOChronology.getInstanceUTC());
        for (Interval interval : intervals) {
            emptyIntervals = false;
            minStart = (DateTime)Collections.min(ImmutableList.of((Object)minStart, (Object)interval.getStart()), dateTimeComp);
            maxEnd = (DateTime)Collections.max(ImmutableList.of((Object)maxEnd, (Object)interval.getEnd()), dateTimeComp);
        }
        if (emptyIntervals) {
            throw new IllegalArgumentException("Empty list of intervals");
        }
        return new Interval((ReadableInstant)minStart, (ReadableInstant)maxEnd);
    }

    public static DateTime minDateTime(DateTime ... times) {
        if (times == null) {
            return null;
        }
        switch (times.length) {
            case 0: {
                return null;
            }
            case 1: {
                return times[0];
            }
        }
        DateTime min = times[0];
        for (int i = 1; i < times.length; ++i) {
            min = min.isBefore((ReadableInstant)times[i]) ? min : times[i];
        }
        return min;
    }

    public static DateTime maxDateTime(DateTime ... times) {
        if (times == null) {
            return null;
        }
        switch (times.length) {
            case 0: {
                return null;
            }
            case 1: {
                return times[0];
            }
        }
        DateTime max = times[0];
        for (int i = 1; i < times.length; ++i) {
            max = max.isAfter((ReadableInstant)times[i]) ? max : times[i];
        }
        return max;
    }
}

