/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;

public class DynamicPartitionsSpec
implements PartitionsSpec {
    public static final long DEFAULT_MAX_TOTAL_ROWS = 20000000L;
    static final String NAME = "dynamic";
    private final int maxRowsPerSegment;
    @Nullable
    private final Long maxTotalRows;

    @JsonCreator
    public DynamicPartitionsSpec(@JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows) {
        this.maxRowsPerSegment = PartitionsSpec.isEffectivelyNull(maxRowsPerSegment) ? 5000000 : maxRowsPerSegment;
        this.maxTotalRows = maxTotalRows;
    }

    @Override
    public SecondaryPartitionType getType() {
        return SecondaryPartitionType.LINEAR;
    }

    @Override
    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @Nullable
    @JsonProperty
    public Long getMaxTotalRows() {
        return this.maxTotalRows;
    }

    public long getMaxTotalRowsOr(long defaultMaxTotalRows) {
        return PartitionsSpec.isEffectivelyNull(this.maxTotalRows) ? defaultMaxTotalRows : this.maxTotalRows;
    }

    @Override
    public boolean needsDeterminePartitions(boolean useForHadoopTask) {
        return false;
    }

    @Override
    public String getForceGuaranteedRollupIncompatiblityReason() {
        return "dynamic partitions unsupported";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicPartitionsSpec that = (DynamicPartitionsSpec)o;
        return this.maxRowsPerSegment == that.maxRowsPerSegment && Objects.equals(this.maxTotalRows, that.maxTotalRows);
    }

    public int hashCode() {
        return Objects.hash(this.maxRowsPerSegment, this.maxTotalRows);
    }

    public String toString() {
        return "DynamicPartitionsSpec{maxRowsPerSegment=" + this.maxRowsPerSegment + ", maxTotalRows=" + this.maxTotalRows + '}';
    }
}

