/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.prefetch;

import com.google.common.base.Predicate;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.RetryingInputStream;
import org.apache.druid.data.input.impl.prefetch.CacheManager;
import org.apache.druid.data.input.impl.prefetch.FetchConfig;
import org.apache.druid.data.input.impl.prefetch.Fetcher;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.data.input.impl.prefetch.OpenObject;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;

public class FileFetcher<T>
extends Fetcher<T> {
    private static final int BUFFER_SIZE = 4096;
    private final ObjectOpenFunction<T> openObjectFunction;
    private final Predicate<Throwable> retryCondition;
    private final byte[] buffer;

    FileFetcher(CacheManager<T> cacheManager, List<T> objects, ExecutorService fetchExecutor, @Nullable File temporaryDirectory, FetchConfig fetchConfig, ObjectOpenFunction<T> openObjectFunction, Predicate<Throwable> retryCondition) {
        super(cacheManager, objects, fetchExecutor, temporaryDirectory, fetchConfig);
        this.openObjectFunction = openObjectFunction;
        this.retryCondition = retryCondition;
        this.buffer = new byte[4096];
    }

    @Override
    protected long download(T object, File outFile) throws IOException {
        return FileUtils.copyLarge(object, this.openObjectFunction, outFile, this.buffer, this.retryCondition, this.getFetchConfig().getMaxFetchRetry() + 1, StringUtils.format("Failed to download object[%s]", object));
    }

    @Override
    protected OpenObject<T> generateOpenObject(T object) throws IOException {
        return new OpenObject<T>(object, new RetryingInputStream<T>(object, this.openObjectFunction, this.retryCondition, this.getFetchConfig().getMaxFetchRetry()), FileFetcher.getNoopCloser());
    }

    private static Closeable getNoopCloser() {
        return () -> {};
    }
}

