/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class RetryingInputStream<T>
extends InputStream {
    private static final Logger log = new Logger(RetryingInputStream.class);
    private final T object;
    private final ObjectOpenFunction<T> objectOpenFunction;
    private final Predicate<Throwable> retryCondition;
    private final int maxTries;
    private CountingInputStream delegate;
    private long startOffset;
    private boolean doWait;

    public RetryingInputStream(T object, ObjectOpenFunction<T> objectOpenFunction, Predicate<Throwable> retryCondition, @Nullable Integer maxTries) throws IOException {
        this.object = Preconditions.checkNotNull(object, (Object)"object");
        this.objectOpenFunction = (ObjectOpenFunction)Preconditions.checkNotNull(objectOpenFunction, (Object)"objectOpenFunction");
        this.retryCondition = (Predicate)Preconditions.checkNotNull(retryCondition, (Object)"retryCondition");
        this.maxTries = maxTries == null ? 10 : maxTries;
        this.delegate = new CountingInputStream(objectOpenFunction.open(object));
        this.doWait = true;
        if (this.maxTries <= 1) {
            throw new IAE("maxTries must be greater than 1", new Object[0]);
        }
    }

    private void openIfNeeded() throws IOException {
        if (this.delegate == null) {
            this.delegate = new CountingInputStream(this.objectOpenFunction.open(this.object, this.startOffset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOrThrow(Throwable t, int nTry) throws IOException {
        this.startOffset += this.delegate.getCount();
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            log.warn(e, "Error while closing the delegate input stream. Discarding.", new Object[0]);
        }
        finally {
            this.delegate = null;
        }
        int nextTry = nTry + 1;
        if (nextTry < this.maxTries && this.retryCondition.apply((Object)t)) {
            try {
                String message = StringUtils.format("Stream interrupted at position [%d]", this.startOffset);
                if (this.doWait) {
                    RetryUtils.awaitNextRetry(t, message, nextTry, this.maxTries, false);
                }
                this.delegate = new CountingInputStream(this.objectOpenFunction.open(this.object, this.startOffset));
            }
            catch (IOException | InterruptedException e) {
                t.addSuppressed(e);
                RetryingInputStream.throwAsIOException(t);
            }
        } else {
            RetryingInputStream.throwAsIOException(t);
        }
    }

    private static void throwAsIOException(Throwable t) throws IOException {
        Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
        throw new IOException(t);
    }

    @Override
    public int read() throws IOException {
        this.openIfNeeded();
        for (int nTry = 0; nTry < this.maxTries; ++nTry) {
            try {
                return this.delegate.read();
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.openIfNeeded();
        for (int nTry = 0; nTry < this.maxTries; ++nTry) {
            try {
                return this.delegate.read(b);
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.openIfNeeded();
        for (int nTry = 0; nTry < this.maxTries; ++nTry) {
            try {
                return this.delegate.read(b, off, len);
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public long skip(long n) throws IOException {
        this.openIfNeeded();
        for (int nTry = 0; nTry < this.maxTries; ++nTry) {
            try {
                return this.delegate.skip(n);
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int available() throws IOException {
        this.openIfNeeded();
        for (int nTry = 0; nTry < this.maxTries; ++nTry) {
            try {
                return this.delegate.available();
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @VisibleForTesting
    void setNoWait() {
        this.doWait = false;
    }
}

