/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.TextReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;

public class JsonLineReader
extends TextReader {
    private final ObjectFlattener<JsonNode> flattener;
    private final ObjectMapper mapper;

    JsonLineReader(InputRowSchema inputRowSchema, InputEntity source, JSONPathSpec flattenSpec, ObjectMapper mapper, boolean keepNullColumns) {
        super(inputRowSchema, source);
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker(keepNullColumns));
        this.mapper = mapper;
    }

    @Override
    public List<InputRow> parseInputRows(String line) throws IOException, ParseException {
        JsonNode document = (JsonNode)this.mapper.readValue(line, JsonNode.class);
        Map<String, Object> flattened = this.flattener.flatten(document);
        return Collections.singletonList(MapInputRowParser.parse(this.getInputRowSchema(), flattened));
    }

    @Override
    public List<Map<String, Object>> toMap(String intermediateRow) throws IOException {
        return Collections.singletonList(this.mapper.readValue(intermediateRow, Map.class));
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return 0;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return false;
    }

    @Override
    public void processHeaderLine(String line) {
    }
}

