/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DelimitedValueReader;
import org.apache.druid.data.input.impl.FlatTextInputFormat;

public class DelimitedInputFormat
extends FlatTextInputFormat {
    public static final String TYPE_KEY = "tsv";
    private static final String DEFAULT_DELIMITER = "\t";

    @JsonCreator
    public DelimitedInputFormat(@JsonProperty(value="columns") @Nullable List<String> columns, @JsonProperty(value="listDelimiter") @Nullable String listDelimiter, @JsonProperty(value="delimiter") @Nullable String delimiter, @Deprecated @JsonProperty(value="hasHeaderRow") @Nullable Boolean hasHeaderRow, @JsonProperty(value="findColumnsFromHeader") @Nullable Boolean findColumnsFromHeader, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
        super(columns, listDelimiter, delimiter == null ? DEFAULT_DELIMITER : delimiter, hasHeaderRow, findColumnsFromHeader, skipHeaderRows);
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new DelimitedValueReader(inputRowSchema, source, this.getListDelimiter(), this.getColumns(), this.isFindColumnsFromHeader(), this.getSkipHeaderRows(), line -> DelimitedInputFormat.splitToList(Splitter.on((String)this.getDelimiter()), line));
    }

    public static List<String> splitToList(Splitter splitter, String input) {
        Preconditions.checkNotNull((Object)input);
        Iterator iterator = splitter.split((CharSequence)input).iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            String splitValue = (String)iterator.next();
            if (!NullHandling.replaceWithDefault() && splitValue.isEmpty()) {
                result.add(null);
                continue;
            }
            result.add(splitValue);
        }
        return Collections.unmodifiableList(result);
    }
}

