/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Ints;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.utils.CollectionUtils;

public abstract class CloudObjectInputSource
extends AbstractInputSource
implements SplittableInputSource<List<CloudObjectLocation>> {
    private final String scheme;
    private final List<URI> uris;
    private final List<URI> prefixes;
    private final List<CloudObjectLocation> objects;
    private final String objectGlob;

    public CloudObjectInputSource(String scheme, @Nullable List<URI> uris, @Nullable List<URI> prefixes, @Nullable List<CloudObjectLocation> objects) {
        this.scheme = scheme;
        this.uris = uris;
        this.prefixes = prefixes;
        this.objects = objects;
        this.objectGlob = null;
        this.illegalArgsChecker();
    }

    public CloudObjectInputSource(String scheme, @Nullable List<URI> uris, @Nullable List<URI> prefixes, @Nullable List<CloudObjectLocation> objects, @Nullable String objectGlob) {
        this.scheme = scheme;
        this.uris = uris;
        this.prefixes = prefixes;
        this.objects = objects;
        this.objectGlob = objectGlob;
        this.illegalArgsChecker();
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<URI> getUris() {
        return this.uris;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<URI> getPrefixes() {
        return this.prefixes;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CloudObjectLocation> getObjects() {
        return this.objects;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getObjectGlob() {
        return this.objectGlob;
    }

    protected abstract InputEntity createEntity(CloudObjectLocation var1);

    protected abstract Stream<InputSplit<List<CloudObjectLocation>>> getPrefixesSplitStream(SplitHintSpec var1);

    @Override
    public Stream<InputSplit<List<CloudObjectLocation>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            Stream<Object> objectStream = this.objects.stream();
            if (StringUtils.isNotBlank((String)this.objectGlob)) {
                PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:" + this.getObjectGlob());
                objectStream = objectStream.filter(object -> m.matches(Paths.get(object.getPath(), new String[0])));
            }
            return objectStream.map(object -> new InputSplit<List<CloudObjectLocation>>(Collections.singletonList(object)));
        }
        if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            Stream<Object> uriStream = this.uris.stream();
            if (StringUtils.isNotBlank((String)this.objectGlob)) {
                PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:" + this.getObjectGlob());
                uriStream = uriStream.filter(uri -> m.matches(Paths.get(uri.toString(), new String[0])));
            }
            return uriStream.map(CloudObjectLocation::new).map(object -> new InputSplit<List<CloudObjectLocation>>(Collections.singletonList(object)));
        }
        return this.getPrefixesSplitStream(this.getSplitHintSpecOrDefault(splitHintSpec));
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            return this.objects.size();
        }
        if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            return this.uris.size();
        }
        return Ints.checkedCast((long)this.getPrefixesSplitStream(this.getSplitHintSpecOrDefault(splitHintSpec)).count());
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, this.createSplits(inputFormat, null).flatMap(split -> ((List)split.get()).stream()).map(this::createEntity).iterator(), temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudObjectInputSource that = (CloudObjectInputSource)o;
        return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.uris, that.uris) && Objects.equals(this.prefixes, that.prefixes) && Objects.equals(this.objects, that.objects) && Objects.equals(this.objectGlob, that.objectGlob);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.uris, this.prefixes, this.objects, this.objectGlob);
    }

    private void illegalArgsChecker() throws IllegalArgumentException {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            this.throwIfIllegalArgs(!CollectionUtils.isNullOrEmpty(this.uris) || !CollectionUtils.isNullOrEmpty(this.prefixes));
        } else if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            this.throwIfIllegalArgs(!CollectionUtils.isNullOrEmpty(this.prefixes));
            this.uris.forEach(uri -> CloudObjectLocation.validateUriScheme(this.scheme, uri));
        } else if (!CollectionUtils.isNullOrEmpty(this.prefixes)) {
            this.prefixes.forEach(uri -> CloudObjectLocation.validateUriScheme(this.scheme, uri));
        } else {
            this.throwIfIllegalArgs(true);
        }
    }

    private void throwIfIllegalArgs(boolean clause) throws IllegalArgumentException {
        if (clause) {
            throw new IllegalArgumentException("exactly one of either uris or prefixes or objects must be specified");
        }
    }
}

