/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IdUtils {
    private static final Pattern INVALIDCHARS = Pattern.compile("(?s).*[^\\S ].*");
    private static final Joiner UNDERSCORE_JOINER = Joiner.on((String)"_");

    public static String validateId(String thingToValidate, String stringToValidate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)stringToValidate) ? 1 : 0) != 0, (String)"%s cannot be null or empty. Please provide a %s.", (Object[])new Object[]{thingToValidate, thingToValidate});
        Preconditions.checkArgument((!stringToValidate.startsWith(".") ? 1 : 0) != 0, (String)"%s cannot start with the '.' character.", (Object[])new Object[]{thingToValidate});
        Preconditions.checkArgument((!stringToValidate.contains("/") ? 1 : 0) != 0, (String)"%s cannot contain the '/' character.", (Object[])new Object[]{thingToValidate});
        Matcher m = INVALIDCHARS.matcher(stringToValidate);
        Preconditions.checkArgument((!m.matches() ? 1 : 0) != 0, (String)"%s cannot contain whitespace character except space.", (Object[])new Object[]{thingToValidate});
        for (int i = 0; i < stringToValidate.length(); ++i) {
            char c = stringToValidate.charAt(i);
            if (!(c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff') && (c <= '\ufff0' || c >= '\uffff')) continue;
            throw new IAE("%s cannot contain character #%d (at position %d).", thingToValidate, (int)c, i);
        }
        return stringToValidate;
    }

    public static String getRandomId() {
        StringBuilder suffix = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            suffix.append((char)(97 + (ThreadLocalRandom.current().nextInt() >>> i * 4 & 0xF)));
        }
        return suffix.toString();
    }

    public static String getRandomIdWithPrefix(String prefix) {
        return UNDERSCORE_JOINER.join((Object)prefix, (Object)IdUtils.getRandomId(), new Object[0]);
    }

    public static String newTaskId(String typeName, String dataSource, @Nullable Interval interval) {
        return IdUtils.newTaskId(null, typeName, dataSource, interval);
    }

    public static String newTaskId(@Nullable String idPrefix, String typeName, String dataSource, @Nullable Interval interval) {
        return IdUtils.newTaskId(idPrefix, IdUtils.getRandomId(), DateTimes.nowUtc(), typeName, dataSource, interval);
    }

    @VisibleForTesting
    static String newTaskId(@Nullable String idPrefix, String idSuffix, DateTime now, String typeName, String dataSource, @Nullable Interval interval) {
        ArrayList<String> objects = new ArrayList<String>();
        if (idPrefix != null) {
            objects.add(idPrefix);
        }
        objects.add(typeName);
        objects.add(dataSource);
        objects.add(idSuffix);
        if (interval != null) {
            objects.add(interval.getStart().toString());
            objects.add(interval.getEnd().toString());
        }
        objects.add(now.toString());
        return String.join((CharSequence)"_", objects);
    }
}

