/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;

public class AuditEntry {
    private final String key;
    private final String type;
    private final AuditInfo auditInfo;
    private final String payload;
    private final DateTime auditTime;

    @JsonCreator
    public AuditEntry(@JsonProperty(value="key") String key, @JsonProperty(value="type") String type, @JsonProperty(value="auditInfo") AuditInfo authorInfo, @JsonProperty(value="payload") String payload, @JsonProperty(value="auditTime") DateTime auditTime) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        Preconditions.checkNotNull((Object)authorInfo, (Object)"author cannot be null");
        this.key = key;
        this.type = type;
        this.auditInfo = authorInfo;
        this.auditTime = auditTime == null ? DateTimes.nowUtc() : auditTime;
        this.payload = payload;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    @JsonProperty
    public String getPayload() {
        return this.payload;
    }

    @JsonProperty
    public DateTime getAuditTime() {
        return this.auditTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditEntry entry = (AuditEntry)o;
        if (!this.auditTime.equals((Object)entry.auditTime)) {
            return false;
        }
        if (!this.auditInfo.equals(entry.auditInfo)) {
            return false;
        }
        if (!this.key.equals(entry.key)) {
            return false;
        }
        if (!this.payload.equals(entry.payload)) {
            return false;
        }
        return this.type.equals(entry.type);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.auditInfo.hashCode();
        result = 31 * result + this.payload.hashCode();
        result = 31 * result + this.auditTime.hashCode();
        return result;
    }

    public static class Builder {
        private String key = null;
        private String type;
        private AuditInfo auditInfo = null;
        private String payload = null;
        private DateTime auditTime = DateTimes.nowUtc();

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder auditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder auditTime(DateTime auditTime) {
            this.auditTime = auditTime;
            return this;
        }

        public AuditEntry build() {
            return new AuditEntry(this.key, this.type, this.auditInfo, this.payload, this.auditTime);
        }
    }
}

