/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.util;

import java.util.function.Supplier;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class ToObjectVectorColumnProcessorFactory
implements VectorColumnProcessorFactory<Supplier<Object[]>> {
    public static final ToObjectVectorColumnProcessorFactory INSTANCE = new ToObjectVectorColumnProcessorFactory();

    private ToObjectVectorColumnProcessorFactory() {
    }

    public Supplier<Object[]> makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
        Object[] retVal = new Object[selector.getMaxVectorSize()];
        return () -> {
            int[] values = selector.getRowVector();
            for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                retVal[i] = selector.lookupName(values[i]);
            }
            return retVal;
        };
    }

    public Supplier<Object[]> makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
        Object[] retVal = new Object[selector.getMaxVectorSize()];
        return () -> {
            IndexedInts[] values = selector.getRowVector();
            for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                retVal[i] = DimensionSelector.rowToObject((IndexedInts)values[i], (DimensionDictionarySelector)selector);
            }
            return retVal;
        };
    }

    public Supplier<Object[]> makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        Object[] retVal = new Object[selector.getMaxVectorSize()];
        return () -> {
            float[] values = selector.getFloatVector();
            boolean[] nulls = selector.getNullVector();
            for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                retVal[i] = nulls == null || !nulls[i] ? Float.valueOf(values[i]) : null;
            }
            return retVal;
        };
    }

    public Supplier<Object[]> makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        Object[] retVal = new Object[selector.getMaxVectorSize()];
        return () -> {
            double[] values = selector.getDoubleVector();
            boolean[] nulls = selector.getNullVector();
            for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                retVal[i] = nulls == null || !nulls[i] ? Double.valueOf(values[i]) : null;
            }
            return retVal;
        };
    }

    public Supplier<Object[]> makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        Object[] retVal = new Object[selector.getMaxVectorSize()];
        return () -> {
            long[] values = selector.getLongVector();
            boolean[] nulls = selector.getNullVector();
            for (int i = 0; i < selector.getCurrentVectorSize(); ++i) {
                retVal[i] = nulls == null || !nulls[i] ? Long.valueOf(values[i]) : null;
            }
            return retVal;
        };
    }

    public Supplier<Object[]> makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
        return () -> ((VectorObjectSelector)selector).getObjectVector();
    }
}

