/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class ArrayOfDoublesSketchBuildBufferAggregator
implements BufferAggregator {
    private final DimensionSelector keySelector;
    private final BaseDoubleColumnValueSelector[] valueSelectors;
    private final int nominalEntries;
    private final int maxIntermediateSize;
    @Nullable
    private double[] values;
    private final boolean canLookupUtf8;
    private final boolean canCacheById;
    private final LinkedHashMap<Integer, Object> stringCache = new LinkedHashMap<Integer, Object>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= 10;
        }
    };

    public ArrayOfDoublesSketchBuildBufferAggregator(DimensionSelector keySelector, List<BaseDoubleColumnValueSelector> valueSelectors, int nominalEntries, int maxIntermediateSize) {
        this.keySelector = keySelector;
        this.valueSelectors = valueSelectors.toArray(new BaseDoubleColumnValueSelector[0]);
        this.nominalEntries = nominalEntries;
        this.maxIntermediateSize = maxIntermediateSize;
        this.values = new double[valueSelectors.size()];
        this.canCacheById = this.keySelector.nameLookupPossibleInAdvance();
        this.canLookupUtf8 = this.keySelector.supportsLookupNameUtf8();
    }

    public void init(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(this.nominalEntries).setNumberOfValues(this.valueSelectors.length).setNumberOfValues(this.valueSelectors.length).build(region);
    }

    public void aggregate(ByteBuffer buf, int position) {
        for (int i = 0; i < this.valueSelectors.length; ++i) {
            if (this.valueSelectors[i].isNull()) {
                return;
            }
            this.values[i] = this.valueSelectors[i].getDouble();
        }
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        ArrayOfDoublesUpdatableSketch sketch = ArrayOfDoublesSketches.wrapUpdatableSketch((WritableMemory)region);
        IndexedInts keys = this.keySelector.getRow();
        if (this.canLookupUtf8) {
            int keysSize = keys.size();
            for (int i = 0; i < keysSize; ++i) {
                ByteBuffer key = this.canCacheById ? (ByteBuffer)this.stringCache.computeIfAbsent(keys.get(i), arg_0 -> ((DimensionSelector)this.keySelector).lookupNameUtf8(arg_0)) : this.keySelector.lookupNameUtf8(keys.get(i));
                if (key == null) continue;
                byte[] bytes = new byte[key.remaining()];
                key.mark();
                key.get(bytes);
                key.reset();
                sketch.update(bytes, this.values);
            }
        } else {
            int keysSize = keys.size();
            for (int i = 0; i < keysSize; ++i) {
                String key = this.canCacheById ? (String)this.stringCache.computeIfAbsent(keys.get(i), arg_0 -> ((DimensionSelector)this.keySelector).lookupName(arg_0)) : this.keySelector.lookupName(keys.get(i));
                sketch.update(key, this.values);
            }
        }
    }

    public Object get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        ArrayOfDoublesUpdatableSketch sketch = (ArrayOfDoublesUpdatableSketch)ArrayOfDoublesSketches.wrapSketch((Memory)region);
        return sketch.compact();
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.values = null;
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("keySelector", (HotLoopCallee)this.keySelector);
        inspector.visit("valueSelectors", (Object[])this.valueSelectors);
    }
}

