/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class ArrayOfDoublesSketchBuildAggregator
implements Aggregator {
    private final DimensionSelector keySelector;
    private final BaseDoubleColumnValueSelector[] valueSelectors;
    @Nullable
    private double[] values;
    @Nullable
    private ArrayOfDoublesUpdatableSketch sketch;
    private final boolean canLookupUtf8;
    private final boolean canCacheById;
    private final LinkedHashMap<Integer, Object> stringCache = new LinkedHashMap<Integer, Object>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= 10;
        }
    };

    public ArrayOfDoublesSketchBuildAggregator(DimensionSelector keySelector, List<BaseDoubleColumnValueSelector> valueSelectors, int nominalEntries) {
        this.keySelector = keySelector;
        this.valueSelectors = valueSelectors.toArray(new BaseDoubleColumnValueSelector[0]);
        this.values = new double[valueSelectors.size()];
        this.sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(nominalEntries).setNumberOfValues(valueSelectors.size()).build();
        this.canCacheById = this.keySelector.nameLookupPossibleInAdvance();
        this.canLookupUtf8 = this.keySelector.supportsLookupNameUtf8();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate() {
        IndexedInts keys = this.keySelector.getRow();
        for (int i = 0; i < this.valueSelectors.length; ++i) {
            if (this.valueSelectors[i].isNull()) {
                return;
            }
            this.values[i] = this.valueSelectors[i].getDouble();
        }
        ArrayOfDoublesSketchBuildAggregator arrayOfDoublesSketchBuildAggregator = this;
        synchronized (arrayOfDoublesSketchBuildAggregator) {
            if (this.canLookupUtf8) {
                int keysSize = keys.size();
                for (int i = 0; i < keysSize; ++i) {
                    ByteBuffer key = this.canCacheById ? (ByteBuffer)this.stringCache.computeIfAbsent(keys.get(i), arg_0 -> ((DimensionSelector)this.keySelector).lookupNameUtf8(arg_0)) : this.keySelector.lookupNameUtf8(keys.get(i));
                    if (key == null) continue;
                    byte[] bytes = new byte[key.remaining()];
                    key.mark();
                    key.get(bytes);
                    key.reset();
                    this.sketch.update(bytes, this.values);
                }
            } else {
                int keysSize = keys.size();
                for (int i = 0; i < keysSize; ++i) {
                    String key = this.canCacheById ? (String)this.stringCache.computeIfAbsent(keys.get(i), arg_0 -> ((DimensionSelector)this.keySelector).lookupName(arg_0)) : this.keySelector.lookupName(keys.get(i));
                    this.sketch.update(key, this.values);
                }
            }
        }
    }

    public synchronized Object get() {
        return this.sketch.compact();
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.sketch = null;
        this.values = null;
    }
}

