/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchModule;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchOperations;
import org.apache.druid.query.aggregation.datasketches.tuple.NoopArrayOfDoublesSketchAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.NoopArrayOfDoublesSketchBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

public class ArrayOfDoublesSketchAggregatorFactory
extends AggregatorFactory {
    public static final Comparator<ArrayOfDoublesSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingDouble(ArrayOfDoublesSketch::getEstimate));
    private final String name;
    private final String fieldName;
    private final int nominalEntries;
    private final int numberOfValues;
    @Nullable
    private final List<String> metricColumns;

    @JsonCreator
    public ArrayOfDoublesSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="nominalEntries") @Nullable Integer nominalEntries, @JsonProperty(value="metricColumns") @Nullable List<String> metricColumns, @JsonProperty(value="numberOfValues") @Nullable Integer numberOfValues) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.nominalEntries = nominalEntries == null ? 4096 : nominalEntries;
        Util.checkIfPowerOf2((int)this.nominalEntries, (String)"nominalEntries");
        this.metricColumns = metricColumns;
        int n = numberOfValues == null ? (metricColumns == null ? 1 : metricColumns.size()) : (this.numberOfValues = numberOfValues.intValue());
        if (metricColumns != null && metricColumns.size() != this.numberOfValues) {
            throw new IAE("Number of metricColumns [%d] must agree with numValues [%d]", new Object[]{metricColumns.size(), this.numberOfValues});
        }
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        if (this.metricColumns == null) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new NoopArrayOfDoublesSketchAggregator(this.numberOfValues);
            }
            return new ArrayOfDoublesSketchMergeAggregator((BaseObjectColumnValueSelector<ArrayOfDoublesSketch>)selector, this.nominalEntries, this.numberOfValues);
        }
        DimensionSelector keySelector = metricFactory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(this.fieldName, this.fieldName));
        if (DimensionSelector.isNilSelector((DimensionSelector)keySelector)) {
            return new NoopArrayOfDoublesSketchAggregator(this.numberOfValues);
        }
        ArrayList<BaseDoubleColumnValueSelector> valueSelectors = new ArrayList<BaseDoubleColumnValueSelector>();
        for (String column : this.metricColumns) {
            ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(column);
            valueSelectors.add((BaseDoubleColumnValueSelector)valueSelector);
        }
        return new ArrayOfDoublesSketchBuildAggregator(keySelector, valueSelectors, this.nominalEntries);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        if (this.metricColumns == null) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new NoopArrayOfDoublesSketchBufferAggregator(this.numberOfValues);
            }
            return new ArrayOfDoublesSketchMergeBufferAggregator((BaseObjectColumnValueSelector<ArrayOfDoublesSketch>)selector, this.nominalEntries, this.numberOfValues, this.getMaxIntermediateSizeWithNulls());
        }
        DimensionSelector keySelector = metricFactory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(this.fieldName, this.fieldName));
        if (DimensionSelector.isNilSelector((DimensionSelector)keySelector)) {
            return new NoopArrayOfDoublesSketchBufferAggregator(this.numberOfValues);
        }
        ArrayList<BaseDoubleColumnValueSelector> valueSelectors = new ArrayList<BaseDoubleColumnValueSelector>();
        for (String column : this.metricColumns) {
            ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(column);
            valueSelectors.add((BaseDoubleColumnValueSelector)valueSelector);
        }
        return new ArrayOfDoublesSketchBuildBufferAggregator(keySelector, valueSelectors, this.nominalEntries, this.getMaxIntermediateSizeWithNulls());
    }

    public Object deserialize(Object object) {
        return ArrayOfDoublesSketchOperations.deserialize(object);
    }

    public Comparator<ArrayOfDoublesSketch> getComparator() {
        return COMPARATOR;
    }

    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.nominalEntries).setNumberOfValues(this.numberOfValues).buildUnion();
        if (lhs != null) {
            union.union((ArrayOfDoublesSketch)lhs);
        }
        if (rhs != null) {
            union.union((ArrayOfDoublesSketch)rhs);
        }
        return union.getResult();
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<ArrayOfDoublesSketch>(){
            private final ArrayOfDoublesUnion union;
            {
                this.union = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(ArrayOfDoublesSketchAggregatorFactory.this.nominalEntries).setNumberOfValues(ArrayOfDoublesSketchAggregatorFactory.this.numberOfValues).buildUnion();
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                ArrayOfDoublesSketch sketch = (ArrayOfDoublesSketch)selector.getObject();
                this.union.union(sketch);
            }

            public ArrayOfDoublesSketch getObject() {
                return this.union.getResult();
            }

            public Class<ArrayOfDoublesSketch> classOfObject() {
                return ArrayOfDoublesSketch.class;
            }
        };
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getNominalEntries() {
        return this.nominalEntries;
    }

    @JsonProperty
    public List<String> getMetricColumns() {
        return this.metricColumns;
    }

    @JsonProperty
    public int getNumberOfValues() {
        return this.numberOfValues;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(33).appendString(this.name).appendString(this.fieldName).appendInt(this.nominalEntries).appendInt(this.numberOfValues);
        if (this.metricColumns != null) {
            builder.appendStrings(this.metricColumns);
        }
        return builder.build();
    }

    public int getMaxIntermediateSize() {
        return ArrayOfDoublesUnion.getMaxBytes((int)this.nominalEntries, (int)this.numberOfValues);
    }

    public AggregatorFactory withName(String newName) {
        return new ArrayOfDoublesSketchAggregatorFactory(newName, this.getFieldName(), this.getNominalEntries(), this.getMetricColumns(), this.getNumberOfValues());
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new ArrayOfDoublesSketchAggregatorFactory(this.fieldName, this.fieldName, this.nominalEntries, this.metricColumns, this.numberOfValues));
    }

    public AggregatorFactory getCombiningFactory() {
        return new ArrayOfDoublesSketchAggregatorFactory(this.name, this.name, this.nominalEntries, null, this.numberOfValues);
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : Double.valueOf(((ArrayOfDoublesSketch)object).getEstimate());
    }

    public ColumnType getIntermediateType() {
        return this.metricColumns == null ? ArrayOfDoublesSketchModule.MERGE_TYPE : ArrayOfDoublesSketchModule.BUILD_TYPE;
    }

    public ColumnType getResultType() {
        return ColumnType.DOUBLE;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{fieldName=" + this.fieldName + ", name=" + this.name + ", nominalEntries=" + this.nominalEntries + ", metricColumns=" + this.metricColumns + ", numberOfValues=" + this.numberOfValues + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArrayOfDoublesSketchAggregatorFactory that = (ArrayOfDoublesSketchAggregatorFactory)((Object)o);
        return this.nominalEntries == that.nominalEntries && this.numberOfValues == that.numberOfValues && this.name.equals(that.name) && this.fieldName.equals(that.fieldName) && Objects.equals(this.metricColumns, that.metricColumns);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.nominalEntries, this.numberOfValues, this.metricColumns);
    }
}

