/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta.sql;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchSetPostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSqlOperators;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public abstract class ThetaSketchSetBaseOperatorConversion
implements SqlOperatorConversion {
    public SqlOperator calciteOperator() {
        return this.makeSqlFunction();
    }

    @Nullable
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return null;
    }

    @Nullable
    public PostAggregator toPostAggregator(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        List operands = ((RexCall)rexNode).getOperands();
        ArrayList<PostAggregator> inputPostAggs = new ArrayList<PostAggregator>();
        Integer size = null;
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = (RexNode)operands.get(i);
            if (i == 0 && operand.isA(SqlKind.LITERAL) && SqlTypeFamily.INTEGER.contains(operand.getType())) {
                size = RexLiteral.intValue((RexNode)operand);
                continue;
            }
            PostAggregator convertedPostAgg = OperatorConversions.toPostAggregator((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)operand, (PostAggregatorVisitor)postAggregatorVisitor, (boolean)true);
            if (convertedPostAgg == null) {
                return null;
            }
            inputPostAggs.add(convertedPostAgg);
        }
        return new SketchSetPostAggregator(postAggregatorVisitor.getOutputNamePrefix() + postAggregatorVisitor.getAndIncrementCounter(), this.getSetOperationName(), size, inputPostAggs);
    }

    private SqlFunction makeSqlFunction() {
        return new SqlFunction(this.getFunctionName(), SqlKind.OTHER_FUNCTION, ThetaSketchSqlOperators.RETURN_TYPE_INFERENCE, null, OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)2)), SqlFunctionCategory.USER_DEFINED_FUNCTION);
    }

    public abstract String getSetOperationName();

    public String getFunctionName() {
        return StringUtils.format((String)"THETA_SKETCH_%s", (Object[])new Object[]{this.getSetOperationName()});
    }
}

