/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.theta.Union;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.util.ToObjectVectorColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class SketchVectorAggregator
implements VectorAggregator {
    private final SketchBufferAggregatorHelper helper;
    private final Supplier<Object[]> objectSupplier;

    SketchVectorAggregator(VectorColumnSelectorFactory columnSelectorFactory, String column, int size, int maxIntermediateSize) {
        this.helper = new SketchBufferAggregatorHelper(size, maxIntermediateSize);
        this.objectSupplier = (Supplier)ColumnProcessors.makeVectorProcessor((String)column, (VectorColumnProcessorFactory)ToObjectVectorColumnProcessorFactory.INSTANCE, (VectorColumnSelectorFactory)columnSelectorFactory);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Union union = this.helper.getOrCreateUnion(buf, position);
        Object[] vector = this.objectSupplier.get();
        for (int i = startRow; i < endRow; ++i) {
            Object o = vector[i];
            if (o == null) continue;
            SketchAggregator.updateUnion(union, o);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.objectSupplier.get();
        for (int i = 0; i < numRows; ++i) {
            Object o = vector[rows != null ? rows[i] : i];
            if (o == null) continue;
            int position = positions[i] + positionOffset;
            Union union = this.helper.getOrCreateUnion(buf, position);
            SketchAggregator.updateUnion(union, o);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }

    public void close() {
        this.helper.close();
    }
}

