/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.Family;
import org.apache.datasketches.Util;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchVectorAggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public abstract class SketchAggregatorFactory
extends AggregatorFactory {
    public static final int DEFAULT_MAX_SKETCH_SIZE = 16384;
    private static final int MIN_ENTRIES_PER_AGGREGATOR = 32;
    private static final int LONGEST_POSSIBLE_PREAMBLE_BYTES = Family.UNION.getMaxPreLongs() << 3;
    protected final String name;
    protected final String fieldName;
    protected final int size;
    private final byte cacheId;

    public SketchAggregatorFactory(String name, String fieldName, Integer size, byte cacheId) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.size = size == null ? 16384 : size;
        Util.checkIfPowerOf2((int)this.size, (String)"size");
        this.cacheId = cacheId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        return new SketchAggregator((BaseObjectColumnValueSelector)selector, this.size);
    }

    public AggregatorAndSize factorizeWithSize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        SketchAggregator aggregator = new SketchAggregator((BaseObjectColumnValueSelector)selector, this.size);
        return new AggregatorAndSize((Aggregator)aggregator, aggregator.getInitialSizeBytes());
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        return new SketchBufferAggregator((BaseObjectColumnValueSelector)selector, this.size, this.getMaxIntermediateSizeWithNulls());
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return new SketchVectorAggregator(selectorFactory, this.fieldName, this.size, this.getMaxIntermediateSizeWithNulls());
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public Object deserialize(Object object) {
        return SketchHolder.deserialize(object);
    }

    public Comparator<Object> getComparator() {
        return SketchHolder.COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        return SketchHolder.combine(lhs, rhs, this.size);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<SketchHolder>(){
            private final Union union;
            private final SketchHolder combined;
            {
                this.union = (Union)SetOperation.builder().setNominalEntries(SketchAggregatorFactory.this.size).build(Family.UNION);
                this.combined = SketchHolder.of(this.union);
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.combined.invalidateCache();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                SketchHolder other = (SketchHolder)selector.getObject();
                if (other != null) {
                    other.updateUnion(this.union);
                    this.combined.invalidateCache();
                }
            }

            public Class<SketchHolder> classOfObject() {
                return SketchHolder.class;
            }

            @Nullable
            public SketchHolder getObject() {
                return this.combined;
            }
        };
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getSize() {
        return this.size;
    }

    public int guessAggregatorHeapFootprint(long rows) {
        int maxEntries = this.size * 2;
        int expectedEntries = rows > (long)maxEntries ? maxEntries : Math.max(32, Util.ceilingPowerOf2((int)Ints.checkedCast((long)rows)));
        return 8 * expectedEntries + LONGEST_POSSIBLE_PREAMBLE_BYTES;
    }

    public int getMaxIntermediateSize() {
        return SetOperation.getMaxUnionBytes((int)this.size);
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(5 + fieldNameBytes.length).put(this.cacheId).putInt(this.size).put(fieldNameBytes).array();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SketchAggregatorFactory that = (SketchAggregatorFactory)((Object)o);
        if (this.size != that.size) {
            return false;
        }
        if (this.cacheId != that.cacheId) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.cacheId;
        return result;
    }
}

