/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.datasketches.SketchQueryContext;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchApproxQuantileSqlAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class DoublesSketchObjectSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new DoublesSketchSqlAggFunction();
    private static final String NAME = "DS_QUANTILES_SKETCH";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        DoublesSketchAggregatorFactory aggregatorFactory;
        int k;
        DruidExpression input = Aggregations.toDruidExpressionForNumericAggregator((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0))));
        if (input == null) {
            return null;
        }
        String histogramName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        if (aggregateCall.getArgList().size() >= 2) {
            RexNode resolutionArg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(1)));
            if (!resolutionArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            k = ((Number)((Object)RexLiteral.value((RexNode)resolutionArg))).intValue();
        } else {
            k = 128;
        }
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = new DoublesSketchAggregatorFactory(histogramName, input.getDirectColumn(), k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), SketchQueryContext.isFinalizeOuterSketches(plannerContext));
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, ColumnType.FLOAT);
            aggregatorFactory = new DoublesSketchAggregatorFactory(histogramName, virtualColumnName, k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), SketchQueryContext.isFinalizeOuterSketches(plannerContext));
        }
        return Aggregation.create((List)ImmutableList.of((Object)((Object)aggregatorFactory)), null);
    }

    private static class DoublesSketchSqlAggFunction
    extends SqlAggFunction {
        private static final String SIGNATURE2 = "'DS_QUANTILES_SKETCH(column, k)'\n";

        DoublesSketchSqlAggFunction() {
            super(DoublesSketchObjectSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER), null, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE2, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.EXACT_NUMERIC})})}), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false);
        }
    }
}

