/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToQuantilePostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class DoublesSketchApproxQuantileSqlAggregator
implements SqlAggregator {
    public static final String CTX_APPROX_QUANTILE_DS_MAX_STREAM_LENGTH = "approxQuantileDsMaxStreamLength";
    private static final SqlAggFunction FUNCTION_INSTANCE = new DoublesSketchApproxQuantileSqlAggFunction();
    private static final String NAME = "APPROX_QUANTILE_DS";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        DoublesSketchAggregatorFactory aggregatorFactory;
        int k;
        DruidExpression input = Aggregations.toDruidExpressionForNumericAggregator((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0))));
        if (input == null) {
            return null;
        }
        String histogramName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        RexNode probabilityArg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(1)));
        if (!probabilityArg.isA(SqlKind.LITERAL)) {
            return null;
        }
        float probability = ((Number)((Object)RexLiteral.value((RexNode)probabilityArg))).floatValue();
        if (aggregateCall.getArgList().size() >= 3) {
            RexNode resolutionArg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(2)));
            if (!resolutionArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            k = ((Number)((Object)RexLiteral.value((RexNode)resolutionArg))).intValue();
        } else {
            k = 128;
        }
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                DoublesSketchAggregatorFactory theFactory;
                DruidExpression virtualInput;
                boolean inputMatches;
                boolean matches;
                if (!(factory instanceof DoublesSketchAggregatorFactory) || !(matches = (inputMatches = (virtualInput = (DruidExpression)virtualColumnRegistry.findVirtualColumnExpressions((theFactory = (DoublesSketchAggregatorFactory)factory).requiredFields()).stream().findFirst().orElse(null)) == null ? input.isDirectColumnAccess() && input.getDirectColumn().equals(theFactory.getFieldName()) : virtualInput.equals((Object)input)) && theFactory.getK() == k)) continue;
                return Aggregation.create((List)ImmutableList.of(), (PostAggregator)new DoublesSketchToQuantilePostAggregator(name, (PostAggregator)new FieldAccessPostAggregator(factory.getName(), factory.getName()), probability));
            }
        }
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = new DoublesSketchAggregatorFactory(histogramName, input.getDirectColumn(), k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), true);
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, ColumnType.FLOAT);
            aggregatorFactory = new DoublesSketchAggregatorFactory(histogramName, virtualColumnName, k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), true);
        }
        return Aggregation.create((List)ImmutableList.of((Object)((Object)aggregatorFactory)), (PostAggregator)new DoublesSketchToQuantilePostAggregator(name, (PostAggregator)new FieldAccessPostAggregator(histogramName, histogramName), probability));
    }

    static long getMaxStreamLengthFromQueryContext(QueryContext queryContext) {
        return queryContext.getLong(CTX_APPROX_QUANTILE_DS_MAX_STREAM_LENGTH, 1000000000L);
    }

    private static class DoublesSketchApproxQuantileSqlAggFunction
    extends SqlAggFunction {
        private static final String SIGNATURE1 = "'APPROX_QUANTILE_DS(column, probability)'\n";
        private static final String SIGNATURE2 = "'APPROX_QUANTILE_DS(column, probability, k)'\n";

        DoublesSketchApproxQuantileSqlAggFunction() {
            super(DoublesSketchApproxQuantileSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), null, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE1, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE2, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.EXACT_NUMERIC})})}), SqlFunctionCategory.NUMERIC, false, false);
        }
    }
}

