/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class DoublesSketchMergeVectorAggregator
implements VectorAggregator {
    private final VectorObjectSelector selector;
    private final DoublesSketchMergeBufferAggregatorHelper helper;

    public DoublesSketchMergeVectorAggregator(VectorObjectSelector selector, int k, int maxIntermediateSize) {
        this.selector = selector;
        this.helper = new DoublesSketchMergeBufferAggregatorHelper(k, maxIntermediateSize);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        DoublesUnion union = this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            DoublesSketch sketch = (DoublesSketch)vector[i];
            if (sketch == null) continue;
            union.update(sketch);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.selector.getObjectVector();
        for (int i = 0; i < numRows; ++i) {
            DoublesSketch sketch = (DoublesSketch)vector[rows != null ? rows[i] : i];
            if (sketch == null) continue;
            int position = positions[i] + positionOffset;
            DoublesUnion union = this.helper.getSketchAtPosition(buf, position);
            union.update(sketch);
        }
    }

    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void close() {
        this.helper.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }
}

