/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.google.common.base.Supplier;
import com.google.common.primitives.Doubles;
import java.nio.ByteBuffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchObjectStrategy;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchOperations;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class DoublesSketchComplexMetricSerde
extends ComplexMetricSerde {
    private static final DoublesSketchObjectStrategy STRATEGY = new DoublesSketchObjectStrategy();

    public String getTypeName() {
        return "quantilesDoublesSketch";
    }

    public ObjectStrategy<DoublesSketch> getObjectStrategy() {
        return STRATEGY;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){
            private static final int MIN_K = 2;

            public Class<?> extractedClass() {
                return DoublesSketch.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object instanceof String) {
                    String objectString = (String)object;
                    if (objectString.isEmpty()) {
                        return DoublesSketchOperations.EMPTY_SKETCH;
                    }
                    Double doubleValue = Doubles.tryParse((String)objectString);
                    if (doubleValue != null) {
                        UpdateDoublesSketch sketch = DoublesSketch.builder().setK(2).build();
                        sketch.update(doubleValue.doubleValue());
                        return sketch;
                    }
                } else if (object instanceof Number) {
                    UpdateDoublesSketch sketch = DoublesSketch.builder().setK(2).build();
                    sketch.update(((Number)object).doubleValue());
                    return sketch;
                }
                if (object == null || object instanceof DoublesSketch || object instanceof Memory) {
                    return object;
                }
                return DoublesSketchOperations.deserializeSafe(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        GenericIndexed column = GenericIndexed.read((ByteBuffer)buffer, (ObjectStrategy)STRATEGY, (SmooshedFileMapper)builder.getFileMapper());
        builder.setComplexColumnSupplier((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, this.getObjectStrategy());
    }
}

