/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllSketch;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchNoOpAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchNoOpBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

abstract class KllSketchAggregatorFactory<SketchType extends KllSketch, ValueType>
extends AggregatorFactory {
    public static final int DEFAULT_K = 200;
    public static final long DEFAULT_MAX_STREAM_LENGTH = 1000000000L;
    private final String name;
    private final String fieldName;
    private final int k;
    private final long maxStreamLength;
    private final byte cacheTypeId;

    KllSketchAggregatorFactory(String name, String fieldName, @Nullable Integer k, @Nullable Long maxStreamLength, byte cacheTypeId) {
        if (name == null) {
            throw new IAE("Must have a valid, non-null aggregator name", new Object[0]);
        }
        this.name = name;
        if (fieldName == null) {
            throw new IAE("Parameter fieldName must be specified", new Object[0]);
        }
        this.fieldName = fieldName;
        this.k = k == null ? 200 : k;
        this.maxStreamLength = maxStreamLength == null ? 1000000000L : maxStreamLength;
        this.cacheTypeId = cacheTypeId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && metricFactory.getColumnCapabilities(this.fieldName).isNumeric()) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new KllSketchNoOpAggregator<SketchType>(this.getEmptySketch());
            }
            return this.getBuildAggregator(selector);
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new KllSketchNoOpAggregator<SketchType>(this.getEmptySketch());
        }
        return this.getMergeAggregator(selector);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && metricFactory.getColumnCapabilities(this.fieldName).isNumeric()) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new KllSketchNoOpBufferAggregator<SketchType>(this.getEmptySketch());
            }
            return this.getBuildBufferAggregator(selector);
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new KllSketchNoOpBufferAggregator<SketchType>(this.getEmptySketch());
        }
        return this.getMergeBufferAggregator(selector);
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public Object combine(Object lhs, Object rhs) {
        SketchType sketch = this.newHeapInstance(this.k);
        sketch.merge((KllSketch)lhs);
        sketch.merge((KllSketch)rhs);
        return sketch;
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<SketchType>(){
            private final SketchType union;
            {
                this.union = KllSketchAggregatorFactory.this.newHeapInstance(KllSketchAggregatorFactory.this.k);
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                KllSketch sketch = (KllSketch)selector.getObject();
                this.union.merge(sketch);
            }

            @Nullable
            public SketchType getObject() {
                return this.union;
            }

            public Class<SketchType> classOfObject() {
                return KllSketchAggregatorFactory.this.getSketchClass();
            }
        };
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getK() {
        return this.k;
    }

    @JsonProperty
    public long getMaxStreamLength() {
        return this.maxStreamLength;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public int guessAggregatorHeapFootprint(long rows) {
        return this.getMaxSerializedSizeBytes(this.k, rows);
    }

    public int getMaxIntermediateSize() {
        return this.getMaxSerializedSizeBytes(this.k, this.maxStreamLength);
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : Long.valueOf(((KllSketch)object).getN());
    }

    public ColumnType getResultType() {
        return ColumnType.LONG;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.cacheTypeId).appendString(this.name).appendString(this.fieldName).appendInt(this.k).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KllSketchAggregatorFactory that = (KllSketchAggregatorFactory)((Object)o);
        return this.k == that.k && this.maxStreamLength == that.maxStreamLength && this.name.equals(that.name) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.k, this.maxStreamLength);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name=" + this.name + ", fieldName=" + this.fieldName + ", k=" + this.k + "}";
    }

    abstract SketchType getEmptySketch();

    abstract SketchType newHeapInstance(int var1);

    abstract Class<SketchType> getSketchClass();

    abstract int getMaxSerializedSizeBytes(int var1, long var2);

    abstract KllSketchBuildAggregator<SketchType, ValueType> getBuildAggregator(ColumnValueSelector<ValueType> var1);

    abstract KllSketchMergeAggregator<SketchType> getMergeAggregator(ColumnValueSelector var1);

    abstract KllSketchBuildBufferAggregator<SketchType, ValueType> getBuildBufferAggregator(ColumnValueSelector<ValueType> var1);

    abstract KllSketchMergeBufferAggregator<SketchType> getMergeBufferAggregator(ColumnValueSelector var1);
}

