/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class KllFloatsSketchToRankPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final float value;

    @JsonCreator
    public KllFloatsSketchToRankPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="value") float value) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.value = value;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public float getValue() {
        return this.value;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        KllFloatsSketch sketch = (KllFloatsSketch)this.field.compute(combinedAggregators);
        return sketch.getRank(this.value);
    }

    public Comparator<Double> getComparator() {
        return Doubles::compare;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(39).appendCacheable((Cacheable)this.field).appendFloat(this.value).build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", field=" + this.field + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KllFloatsSketchToRankPostAggregator that = (KllFloatsSketchToRankPostAggregator)o;
        return Float.compare(that.value, this.value) == 0 && this.name.equals(that.name) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field, Float.valueOf(this.value));
    }
}

