/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.google.common.base.Supplier;
import com.google.common.primitives.Floats;
import java.nio.ByteBuffer;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchObjectStrategy;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchOperations;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class KllFloatsSketchComplexMetricSerde
extends ComplexMetricSerde {
    private static final KllFloatsSketchObjectStrategy STRATEGY = new KllFloatsSketchObjectStrategy();

    public String getTypeName() {
        return "KllFloatsSketch";
    }

    public ObjectStrategy<KllFloatsSketch> getObjectStrategy() {
        return STRATEGY;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){
            private static final int MIN_K = 8;

            public Class<?> extractedClass() {
                return KllFloatsSketch.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object instanceof String) {
                    String objectString = (String)object;
                    if (objectString.isEmpty()) {
                        return KllFloatsSketchOperations.EMPTY_SKETCH;
                    }
                    Float floatValue = Floats.tryParse((String)objectString);
                    if (floatValue != null) {
                        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)8);
                        sketch.update(floatValue.floatValue());
                        return sketch;
                    }
                } else if (object instanceof Number) {
                    KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)8);
                    sketch.update(((Number)object).floatValue());
                    return sketch;
                }
                if (object == null || object instanceof KllFloatsSketch || object instanceof Memory) {
                    return object;
                }
                return KllFloatsSketchOperations.deserializeSafe(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        GenericIndexed column = GenericIndexed.read((ByteBuffer)buffer, (ObjectStrategy)STRATEGY, (SmooshedFileMapper)builder.getFileMapper());
        builder.setComplexColumnSupplier((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, this.getObjectStrategy());
    }
}

