/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchBuildVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchMergeVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchOperations;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchModule;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchNoOpBufferAggregator;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class KllFloatsSketchAggregatorFactory
extends KllSketchAggregatorFactory<KllFloatsSketch, Float> {
    public static final Comparator<KllFloatsSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(KllSketch::getN));

    @JsonCreator
    public KllFloatsSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="k") @Nullable Integer k, @JsonProperty(value="maxStreamLength") @Nullable Long maxStreamLength) {
        this(name, fieldName, k, maxStreamLength, 74);
    }

    KllFloatsSketchAggregatorFactory(String name, String fieldName, @Nullable Integer k, @Nullable Long maxStreamLength, byte cacheTypeId) {
        super(name, fieldName, k, maxStreamLength, cacheTypeId);
    }

    public Comparator<KllFloatsSketch> getComparator() {
        return COMPARATOR;
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new KllFloatsSketchAggregatorFactory(this.getFieldName(), this.getFieldName(), this.getK(), this.getMaxStreamLength()));
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof KllFloatsSketchAggregatorFactory) {
            return new KllFloatsSketchMergeAggregatorFactory(this.getName(), Math.max(this.getK(), ((KllFloatsSketchAggregatorFactory)other).getK()), Math.max(this.getMaxStreamLength(), ((KllFloatsSketchAggregatorFactory)other).getMaxStreamLength()));
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public AggregatorFactory getCombiningFactory() {
        return new KllFloatsSketchMergeAggregatorFactory(this.getName(), this.getK(), this.getMaxStreamLength());
    }

    @Override
    KllFloatsSketch getEmptySketch() {
        return KllFloatsSketchOperations.EMPTY_SKETCH;
    }

    @Override
    KllFloatsSketch newHeapInstance(int k) {
        return KllFloatsSketch.newHeapInstance((int)k);
    }

    @Override
    Class<KllFloatsSketch> getSketchClass() {
        return KllFloatsSketch.class;
    }

    @Override
    int getMaxSerializedSizeBytes(int k, long n) {
        return KllFloatsSketch.getMaxSerializedSizeBytes((int)k, (long)n, (boolean)true);
    }

    @Override
    KllSketchBuildAggregator<KllFloatsSketch, Float> getBuildAggregator(ColumnValueSelector<Float> selector) {
        return new KllFloatsSketchBuildAggregator(selector, this.getK());
    }

    @Override
    KllSketchMergeAggregator<KllFloatsSketch> getMergeAggregator(ColumnValueSelector selector) {
        return new KllFloatsSketchMergeAggregator(selector, this.getK());
    }

    KllFloatsSketchBuildBufferAggregator getBuildBufferAggregator(ColumnValueSelector<Float> selector) {
        return new KllFloatsSketchBuildBufferAggregator(selector, this.getK(), this.getMaxIntermediateSizeWithNulls());
    }

    KllFloatsSketchMergeBufferAggregator getMergeBufferAggregator(ColumnValueSelector selector) {
        return new KllFloatsSketchMergeBufferAggregator((ColumnValueSelector<KllFloatsSketch>)selector, this.getK(), this.getMaxIntermediateSizeWithNulls());
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return (VectorAggregator)ColumnProcessors.makeVectorProcessor((String)this.getFieldName(), (VectorColumnProcessorFactory)new VectorColumnProcessorFactory<VectorAggregator>(){

            public VectorAggregator makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
                return new KllSketchNoOpBufferAggregator<KllFloatsSketch>(KllFloatsSketchAggregatorFactory.this.getEmptySketch());
            }

            public VectorAggregator makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
                return new KllSketchNoOpBufferAggregator<KllFloatsSketch>(KllFloatsSketchAggregatorFactory.this.getEmptySketch());
            }

            public VectorAggregator makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new KllFloatsSketchBuildVectorAggregator(selector, KllFloatsSketchAggregatorFactory.this.getK(), KllFloatsSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new KllFloatsSketchBuildVectorAggregator(selector, KllFloatsSketchAggregatorFactory.this.getK(), KllFloatsSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new KllFloatsSketchBuildVectorAggregator(selector, KllFloatsSketchAggregatorFactory.this.getK(), KllFloatsSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
                return new KllFloatsSketchMergeVectorAggregator(selector, KllFloatsSketchAggregatorFactory.this.getK(), KllFloatsSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }
        }, (VectorColumnSelectorFactory)selectorFactory);
    }

    public Object deserialize(Object object) {
        return KllFloatsSketchOperations.deserialize(object);
    }

    public ColumnType getIntermediateType() {
        return KllSketchModule.FLOATS_TYPE;
    }
}

