/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchBuildVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchMergeVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchOperations;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchModule;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchNoOpBufferAggregator;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class KllDoublesSketchAggregatorFactory
extends KllSketchAggregatorFactory<KllDoublesSketch, Double> {
    public static final Comparator<KllDoublesSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(KllSketch::getN));

    @JsonCreator
    public KllDoublesSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="k") @Nullable Integer k, @JsonProperty(value="maxStreamLength") @Nullable Long maxStreamLength) {
        this(name, fieldName, k, maxStreamLength, 72);
    }

    KllDoublesSketchAggregatorFactory(String name, String fieldName, @Nullable Integer k, @Nullable Long maxStreamLength, byte cacheTypeId) {
        super(name, fieldName, k, maxStreamLength, cacheTypeId);
    }

    public Comparator<KllDoublesSketch> getComparator() {
        return COMPARATOR;
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new KllDoublesSketchAggregatorFactory(this.getFieldName(), this.getFieldName(), this.getK(), this.getMaxStreamLength()));
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof KllDoublesSketchAggregatorFactory) {
            return new KllDoublesSketchMergeAggregatorFactory(this.getName(), Math.max(this.getK(), ((KllDoublesSketchAggregatorFactory)other).getK()), Math.max(this.getMaxStreamLength(), ((KllDoublesSketchAggregatorFactory)other).getMaxStreamLength()));
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public AggregatorFactory getCombiningFactory() {
        return new KllDoublesSketchMergeAggregatorFactory(this.getName(), this.getK(), this.getMaxStreamLength());
    }

    @Override
    KllDoublesSketch getEmptySketch() {
        return KllDoublesSketchOperations.EMPTY_SKETCH;
    }

    @Override
    KllDoublesSketch newHeapInstance(int k) {
        return KllDoublesSketch.newHeapInstance((int)k);
    }

    @Override
    Class<KllDoublesSketch> getSketchClass() {
        return KllDoublesSketch.class;
    }

    @Override
    int getMaxSerializedSizeBytes(int k, long n) {
        return KllDoublesSketch.getMaxSerializedSizeBytes((int)k, (long)n, (boolean)true);
    }

    @Override
    KllSketchBuildAggregator<KllDoublesSketch, Double> getBuildAggregator(ColumnValueSelector<Double> selector) {
        return new KllDoublesSketchBuildAggregator(selector, this.getK());
    }

    @Override
    KllSketchMergeAggregator<KllDoublesSketch> getMergeAggregator(ColumnValueSelector selector) {
        return new KllDoublesSketchMergeAggregator(selector, this.getK());
    }

    KllDoublesSketchBuildBufferAggregator getBuildBufferAggregator(ColumnValueSelector<Double> selector) {
        return new KllDoublesSketchBuildBufferAggregator(selector, this.getK(), this.getMaxIntermediateSizeWithNulls());
    }

    KllDoublesSketchMergeBufferAggregator getMergeBufferAggregator(ColumnValueSelector selector) {
        return new KllDoublesSketchMergeBufferAggregator((ColumnValueSelector<KllDoublesSketch>)selector, this.getK(), this.getMaxIntermediateSizeWithNulls());
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return (VectorAggregator)ColumnProcessors.makeVectorProcessor((String)this.getFieldName(), (VectorColumnProcessorFactory)new VectorColumnProcessorFactory<VectorAggregator>(){

            public VectorAggregator makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
                return new KllSketchNoOpBufferAggregator<KllDoublesSketch>(KllDoublesSketchAggregatorFactory.this.getEmptySketch());
            }

            public VectorAggregator makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
                return new KllSketchNoOpBufferAggregator<KllDoublesSketch>(KllDoublesSketchAggregatorFactory.this.getEmptySketch());
            }

            public VectorAggregator makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new KllDoublesSketchBuildVectorAggregator(selector, KllDoublesSketchAggregatorFactory.this.getK(), KllDoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new KllDoublesSketchBuildVectorAggregator(selector, KllDoublesSketchAggregatorFactory.this.getK(), KllDoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new KllDoublesSketchBuildVectorAggregator(selector, KllDoublesSketchAggregatorFactory.this.getK(), KllDoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
                return new KllDoublesSketchMergeVectorAggregator(selector, KllDoublesSketchAggregatorFactory.this.getK(), KllDoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }
        }, (VectorColumnSelectorFactory)selectorFactory);
    }

    public Object deserialize(Object object) {
        return KllDoublesSketchOperations.deserialize(object);
    }

    public ColumnType getIntermediateType() {
        return KllSketchModule.DOUBLES_TYPE;
    }
}

