/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class HllSketchToStringPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;

    @JsonCreator
    public HllSketchToStringPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field) {
        this.name = name;
        this.field = field;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    public Comparator<String> getComparator() {
        return Comparator.nullsFirst(Comparator.naturalOrder());
    }

    public String compute(Map<String, Object> combinedAggregators) {
        HllSketch sketch = (HllSketch)this.field.compute(combinedAggregators);
        return sketch.toString();
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.STRING;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(49).appendString(this.name).appendCacheable((Cacheable)this.field).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", field=" + this.field + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HllSketchToStringPostAggregator that = (HllSketchToStringPostAggregator)o;
        return this.name.equals(that.name) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field);
    }
}

