/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SafeWritableMemory;

public class HllSketchObjectStrategy
implements ObjectStrategy<HllSketch> {
    static final HllSketchObjectStrategy STRATEGY = new HllSketchObjectStrategy();

    public Class<HllSketch> getClazz() {
        return HllSketch.class;
    }

    public int compare(HllSketch sketch1, HllSketch sketch2) {
        return HllSketchAggregatorFactory.COMPARATOR.compare(sketch1, sketch2);
    }

    public HllSketch fromByteBuffer(ByteBuffer buf, int size) {
        return HllSketch.wrap((Memory)Memory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buf.position(), (long)size));
    }

    public byte[] toBytes(HllSketch sketch) {
        return sketch.toCompactByteArray();
    }

    @Nullable
    public HllSketch fromByteBufferSafe(ByteBuffer buffer, int numBytes) {
        return HllSketch.wrap((Memory)SafeWritableMemory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }
}

