/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.util.ToObjectVectorColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HllSketchMergeVectorAggregator
implements VectorAggregator {
    private final HllSketchMergeBufferAggregatorHelper helper;
    private final Supplier<Object[]> objectSupplier;

    HllSketchMergeVectorAggregator(VectorColumnSelectorFactory columnSelectorFactory, String column, int lgK, TgtHllType tgtHllType, int size) {
        this.helper = new HllSketchMergeBufferAggregatorHelper(lgK, tgtHllType, size);
        this.objectSupplier = (Supplier)ColumnProcessors.makeVectorProcessor((String)column, (VectorColumnProcessorFactory)ToObjectVectorColumnProcessorFactory.INSTANCE, (VectorColumnSelectorFactory)columnSelectorFactory);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.objectSupplier.get();
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.helper.getSize());
        Union union = Union.writableWrap((WritableMemory)mem);
        for (int i = startRow; i < endRow; ++i) {
            union.update((HllSketch)vector[i]);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.objectSupplier.get();
        for (int i = 0; i < numRows; ++i) {
            HllSketch o = (HllSketch)vector[rows != null ? rows[i] : i];
            if (o == null) continue;
            int position = positions[i] + positionOffset;
            WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.helper.getSize());
            Union union = Union.writableWrap((WritableMemory)mem);
            union.update(o);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void close() {
    }
}

