/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.WritableMemory;

public class HllSketchMergeBufferAggregatorHelper {
    private final int lgK;
    private final TgtHllType tgtHllType;
    private final int size;
    private final byte[] emptyUnion;

    public HllSketchMergeBufferAggregatorHelper(int lgK, TgtHllType tgtHllType, int size) {
        this.lgK = lgK;
        this.tgtHllType = tgtHllType;
        this.size = size;
        this.emptyUnion = new byte[size];
        new Union(lgK, WritableMemory.writableWrap((byte[])this.emptyUnion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            buf.put(this.emptyUnion);
        }
        finally {
            buf.position(oldPosition);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.size);
        Union union = Union.writableWrap((WritableMemory)mem);
        return union.getResult(this.tgtHllType);
    }

    public int getLgK() {
        return this.lgK;
    }

    public int getSize() {
        return this.size;
    }
}

