/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchMergeBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<HllSketch> selector;
    private final HllSketchMergeBufferAggregatorHelper helper;

    public HllSketchMergeBufferAggregator(ColumnValueSelector<HllSketch> selector, int lgK, TgtHllType tgtHllType, int size) {
        this.selector = selector;
        this.helper = new HllSketchMergeBufferAggregatorHelper(lgK, tgtHllType, size);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        HllSketch sketch = (HllSketch)this.selector.getObject();
        if (sketch == null) {
            return;
        }
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.helper.getSize());
        Union union = Union.writableWrap((WritableMemory)mem);
        union.update(sketch);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void close() {
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("lgK", (Object)this.helper.getLgK());
    }
}

