/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.util.ToObjectVectorColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HllSketchBuildVectorAggregator
implements VectorAggregator {
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final Supplier<Object[]> objectSupplier;

    HllSketchBuildVectorAggregator(VectorColumnSelectorFactory columnSelectorFactory, String column, int lgK, TgtHllType tgtHllType, int size) {
        this.helper = new HllSketchBuildBufferAggregatorHelper(lgK, tgtHllType, size);
        this.objectSupplier = (Supplier)ColumnProcessors.makeVectorProcessor((String)column, (VectorColumnProcessorFactory)ToObjectVectorColumnProcessorFactory.INSTANCE, (VectorColumnSelectorFactory)columnSelectorFactory);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.objectSupplier.get();
        for (int i = startRow; i < endRow; ++i) {
            Object value = vector[i];
            if (value == null) continue;
            HllSketchBuildAggregator.updateSketch(this.helper.getSketchAtPosition(buf, position), value);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.objectSupplier.get();
        for (int i = 0; i < numRows; ++i) {
            Object o = vector[rows != null ? rows[i] : i];
            if (o == null) continue;
            int position = positions[i] + positionOffset;
            HllSketchBuildAggregator.updateSketch(this.helper.getSketchAtPosition(buf, position), o);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        this.helper.relocate(oldPosition, newPosition, oldBuf, newBuf);
    }

    public void close() {
        this.helper.clear();
    }
}

