/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

public class HllSketchBuildBufferAggregatorHelper {
    private static final MemoryRequestServer MEM_REQ_SERVER = new DefaultMemoryRequestServer();
    private final int lgK;
    private final int size;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<HllSketch>> sketchCache = new IdentityHashMap();
    private final byte[] emptySketch;

    public HllSketchBuildBufferAggregatorHelper(int lgK, TgtHllType tgtHllType, int size) {
        this.lgK = lgK;
        this.size = size;
        this.emptySketch = new byte[size];
        new HllSketch(lgK, tgtHllType, WritableMemory.writableWrap((byte[])this.emptySketch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            buf.put(this.emptySketch);
        }
        finally {
            buf.position(oldPosition);
        }
        WritableMemory mem = this.getMemory(buf).writableRegion((long)position, (long)this.size);
        this.putSketchIntoCache(buf, position, HllSketch.writableWrap((WritableMemory)mem));
    }

    public Object get(ByteBuffer buf, int position) {
        return ((HllSketch)this.sketchCache.get(buf).get(position)).copy();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        WritableMemory oldMem;
        HllSketch sketch = (HllSketch)this.sketchCache.get(oldBuf).get(oldPosition);
        if (sketch.isSameResource((Memory)(oldMem = this.getMemory(oldBuf).writableRegion((long)oldPosition, (long)this.size)))) {
            WritableMemory newMem = this.getMemory(newBuf).writableRegion((long)newPosition, (long)this.size);
            sketch = HllSketch.writableWrap((WritableMemory)newMem);
        }
        this.putSketchIntoCache(newBuf, newPosition, sketch);
    }

    public HllSketch getSketchAtPosition(ByteBuffer buf, int position) {
        return (HllSketch)this.sketchCache.get(buf).get(position);
    }

    public void clear() {
        this.memCache.clear();
        this.sketchCache.clear();
    }

    public int getLgK() {
        return this.lgK;
    }

    private WritableMemory getMemory(ByteBuffer buf) {
        return this.memCache.computeIfAbsent(buf, b -> WritableMemory.writableWrap((ByteBuffer)b, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)MEM_REQ_SERVER));
    }

    private void putSketchIntoCache(ByteBuffer buf, int position, HllSketch sketch) {
        Int2ObjectMap map = this.sketchCache.computeIfAbsent(buf, b -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)sketch);
    }
}

