/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchBuildBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<Object> selector;
    private final HllSketchBuildBufferAggregatorHelper helper;

    public HllSketchBuildBufferAggregator(ColumnValueSelector<Object> selector, int lgK, TgtHllType tgtHllType, int size) {
        this.selector = selector;
        this.helper = new HllSketchBuildBufferAggregatorHelper(lgK, tgtHllType, size);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        Object value = this.selector.getObject();
        if (value == null) {
            return;
        }
        HllSketchBuildAggregator.updateSketch(this.helper.getSketchAtPosition(buf, position), value);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void close() {
        this.helper.clear();
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        this.helper.relocate(oldPosition, newPosition, oldBuf, newBuf);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("lgK", (Object)this.helper.getLgK());
    }
}

