/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildVectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HllSketchBuildAggregatorFactory
extends HllSketchAggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"HLLSketchBuild");

    @JsonCreator
    public HllSketchBuildAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="lgK") @Nullable Integer lgK, @JsonProperty(value="tgtHllType") @Nullable String tgtHllType, @JsonProperty(value="shouldFinalize") Boolean shouldFinalize, @JsonProperty(value="round") boolean round) {
        super(name, fieldName, lgK, tgtHllType, shouldFinalize, round);
    }

    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    protected byte getCacheTypeId() {
        return 46;
    }

    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
        this.validateInputs(columnSelectorFactory.getColumnCapabilities(this.getFieldName()));
        return new HllSketchBuildAggregator((ColumnValueSelector<Object>)selector, this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()));
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
        this.validateInputs(columnSelectorFactory.getColumnCapabilities(this.getFieldName()));
        return new HllSketchBuildBufferAggregator((ColumnValueSelector<Object>)selector, this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()), this.getMaxIntermediateSize());
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        this.validateInputs(selectorFactory.getColumnCapabilities(this.getFieldName()));
        return new HllSketchBuildVectorAggregator(selectorFactory, this.getFieldName(), this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()), this.getMaxIntermediateSize());
    }

    public int getMaxIntermediateSize() {
        return HllSketch.getMaxUpdatableSerializationBytes((int)this.getLgK(), (TgtHllType)TgtHllType.valueOf((String)this.getTgtHllType()));
    }

    public AggregatorFactory withName(String newName) {
        return new HllSketchBuildAggregatorFactory(newName, this.getFieldName(), this.getLgK(), this.getTgtHllType(), this.isShouldFinalize(), this.isRound());
    }

    private void validateInputs(@Nullable ColumnCapabilities capabilities) {
        if (capabilities != null && capabilities.is((TypeDescriptor)ValueType.COMPLEX)) {
            throw new ISE("Invalid input [%s] of type [%s] for [%s] aggregator [%s]", new Object[]{this.getFieldName(), capabilities.asTypeString(), "HLLSketchBuild", this.getName()});
        }
    }
}

