/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.util.List;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchBuildAggregator
implements Aggregator {
    private final ColumnValueSelector<Object> selector;
    private HllSketch sketch;

    public HllSketchBuildAggregator(ColumnValueSelector<Object> selector, int lgK, TgtHllType tgtHllType) {
        this.selector = selector;
        this.sketch = new HllSketch(lgK, tgtHllType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate() {
        Object value = this.selector.getObject();
        if (value == null) {
            return;
        }
        HllSketchBuildAggregator hllSketchBuildAggregator = this;
        synchronized (hllSketchBuildAggregator) {
            HllSketchBuildAggregator.updateSketch(this.sketch, value);
        }
    }

    public synchronized Object get() {
        return this.sketch.copy();
    }

    public void close() {
        this.sketch = null;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    static void updateSketch(HllSketch sketch, Object value) {
        if (value instanceof Integer || value instanceof Long) {
            sketch.update(((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            sketch.update(((Number)value).doubleValue());
        } else if (value instanceof String) {
            sketch.update(((String)value).toCharArray());
        } else if (value instanceof List) {
            for (Object entry : (List)value) {
                String asString;
                if (entry == null || NullHandling.isNullOrEquivalent((String)(asString = entry.toString()))) continue;
                sketch.update(asString);
            }
        } else if (value instanceof char[]) {
            sketch.update((char[])value);
        } else if (value instanceof byte[]) {
            sketch.update((byte[])value);
        } else if (value instanceof int[]) {
            sketch.update((int[])value);
        } else if (value instanceof long[]) {
            sketch.update((long[])value);
        } else {
            throw new IAE("Unsupported type " + value.getClass(), new Object[0]);
        }
    }
}

