/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.jackson.DefaultTrueJsonIncludeFilter;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeComplexMetricSerde;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

public abstract class HllSketchAggregatorFactory
extends AggregatorFactory {
    public static final boolean DEFAULT_ROUND = false;
    public static final boolean DEFAULT_SHOULD_FINALIZE = true;
    public static final int DEFAULT_LG_K = 12;
    public static final TgtHllType DEFAULT_TGT_HLL_TYPE = TgtHllType.HLL_4;
    static final Comparator<HllSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingDouble(HllSketch::getEstimate));
    private final String name;
    private final String fieldName;
    private final int lgK;
    private final TgtHllType tgtHllType;
    private final boolean shouldFinalize;
    private final boolean round;

    HllSketchAggregatorFactory(String name, String fieldName, @Nullable Integer lgK, @Nullable String tgtHllType, Boolean shouldFinalize, boolean round) {
        this.name = Objects.requireNonNull(name);
        this.fieldName = Objects.requireNonNull(fieldName);
        this.lgK = lgK == null ? 12 : lgK;
        this.tgtHllType = tgtHllType == null ? DEFAULT_TGT_HLL_TYPE : TgtHllType.valueOf((String)tgtHllType);
        this.shouldFinalize = shouldFinalize == null ? true : shouldFinalize;
        this.round = round;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getLgK() {
        return this.lgK;
    }

    @JsonProperty
    public String getTgtHllType() {
        return this.tgtHllType.toString();
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=DefaultTrueJsonIncludeFilter.class)
    public boolean isShouldFinalize() {
        return this.shouldFinalize;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isRound() {
        return this.round;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new HllSketchBuildAggregatorFactory(this.fieldName, this.fieldName, this.lgK, this.tgtHllType.toString(), this.shouldFinalize, this.round));
    }

    public HllSketch deserialize(Object object) {
        return HllSketchMergeComplexMetricSerde.deserializeSketch(object);
    }

    public HllSketch combine(Object objectA, Object objectB) {
        Union union = new Union(this.lgK);
        union.update((HllSketch)objectA);
        union.update((HllSketch)objectB);
        return union.getResult(this.tgtHllType);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<HllSketch>(){
            private final Union union;
            {
                this.union = new Union(HllSketchAggregatorFactory.this.lgK);
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                HllSketch sketch = (HllSketch)selector.getObject();
                this.union.update(sketch);
            }

            @Nullable
            public HllSketch getObject() {
                return this.union.getResult(HllSketchAggregatorFactory.this.tgtHllType);
            }

            public Class<HllSketch> classOfObject() {
                return HllSketch.class;
            }
        };
    }

    public ColumnType getResultType() {
        return this.round ? ColumnType.LONG : ColumnType.DOUBLE;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (!this.shouldFinalize || object == null) {
            return object;
        }
        HllSketch sketch = (HllSketch)object;
        double estimate = sketch.getEstimate();
        if (this.round) {
            return Math.round(estimate);
        }
        return estimate;
    }

    public Comparator<HllSketch> getComparator() {
        return COMPARATOR;
    }

    public AggregatorFactory getCombiningFactory() {
        return new HllSketchMergeAggregatorFactory(this.getName(), this.getName(), this.getLgK(), this.getTgtHllType(), this.isShouldFinalize(), this.isRound());
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.getCacheTypeId()).appendString(this.name).appendString(this.fieldName).appendInt(this.lgK).appendInt(this.tgtHllType.ordinal()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HllSketchAggregatorFactory that = (HllSketchAggregatorFactory)((Object)o);
        return this.lgK == that.lgK && this.shouldFinalize == that.shouldFinalize && this.round == that.round && Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName) && this.tgtHllType == that.tgtHllType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.lgK, this.tgtHllType, this.shouldFinalize, this.round);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", lgK=" + this.lgK + ", tgtHllType=" + this.tgtHllType + (!this.shouldFinalize ? ", shouldFinalize=" + this.shouldFinalize : "") + (this.round ? ", round=" + this.round : "") + '}';
    }

    protected abstract byte getCacheTypeId();
}

