/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.concurrent.ExecutorServices;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.lookup.namespace.NamespaceExtractionConfig;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;

public abstract class NamespaceExtractionCacheManager {
    private static final Logger log = new Logger(NamespaceExtractionCacheManager.class);
    private final ScheduledThreadPoolExecutor scheduledExecutorService;

    public NamespaceExtractionCacheManager(Lifecycle lifecycle, ServiceEmitter serviceEmitter, NamespaceExtractionConfig config) {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(config.getNumExtractionThreads(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NamespaceExtractionCacheManager-%d").setPriority(1).build());
        ExecutorServices.manageLifecycle((Lifecycle)lifecycle, (ExecutorService)this.scheduledExecutorService);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            block2: {
                try {
                    this.monitor(serviceEmitter);
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Error emitting namespace stats", new Object[0]);
                    if (!Thread.currentThread().isInterrupted()) break block2;
                    throw new RuntimeException(e);
                }
            }
        }, 1L, 10L, TimeUnit.MINUTES);
    }

    final ScheduledThreadPoolExecutor scheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @VisibleForTesting
    boolean waitForServiceToEnd(long time, TimeUnit unit) throws InterruptedException {
        return this.scheduledExecutorService.awaitTermination(time, unit);
    }

    public abstract CacheHandler createCache();

    public abstract CacheHandler allocateCache();

    public abstract CacheHandler attachCache(CacheHandler var1);

    abstract void disposeCache(CacheHandler var1);

    abstract int cacheCount();

    abstract void monitor(ServiceEmitter var1);
}

