/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.query.lookup.NamespaceLookupIntrospectHandler;
import org.apache.druid.query.lookup.namespace.ExtractionNamespace;
import org.apache.druid.server.lookup.namespace.cache.CacheScheduler;

@JsonTypeName(value="cachedNamespace")
public class NamespaceLookupExtractorFactory
implements LookupExtractorFactory {
    private static final Logger LOG = new Logger(NamespaceLookupExtractorFactory.class);
    private static final byte[] CLASS_CACHE_KEY;
    CacheScheduler.Entry entry = null;
    private final ReadWriteLock startStopSync = new ReentrantReadWriteLock();
    private final CacheScheduler cacheScheduler;
    private final LookupIntrospectHandler lookupIntrospectHandler;
    private final ExtractionNamespace extractionNamespace;
    private final long firstCacheTimeout;
    private final boolean injective;
    private final String extractorID;

    @JsonCreator
    public NamespaceLookupExtractorFactory(@JsonProperty(value="extractionNamespace") ExtractionNamespace extractionNamespace, @JsonProperty(value="firstCacheTimeout") long firstCacheTimeout, @JsonProperty(value="injective") boolean injective, @JacksonInject CacheScheduler cacheScheduler) {
        this.extractionNamespace = (ExtractionNamespace)Preconditions.checkNotNull((Object)extractionNamespace, (Object)"extractionNamespace should be specified");
        this.firstCacheTimeout = firstCacheTimeout;
        Preconditions.checkArgument((this.firstCacheTimeout >= 0L ? 1 : 0) != 0);
        this.injective = injective;
        this.cacheScheduler = cacheScheduler;
        this.extractorID = StringUtils.format((String)"namespace-factory-%s-%s", (Object[])new Object[]{extractionNamespace, UUID.randomUUID().toString()});
        this.lookupIntrospectHandler = new NamespaceLookupIntrospectHandler(this);
    }

    @VisibleForTesting
    public NamespaceLookupExtractorFactory(ExtractionNamespace extractionNamespace, CacheScheduler cacheScheduler) {
        this(extractionNamespace, 60000L, false, cacheScheduler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start() {
        Lock writeLock = this.startStopSync.writeLock();
        try {
            writeLock.lockInterruptibly();
            try {
                if (this.entry != null) {
                    LOG.warn("Already started! [%s]", new Object[]{this.extractorID});
                    boolean bl = true;
                    return bl;
                }
                if (this.firstCacheTimeout > 0L) {
                    this.entry = this.cacheScheduler.scheduleAndWait(this.extractionNamespace, this.firstCacheTimeout);
                    if (this.entry == null) {
                        LOG.error("Failed to schedule and wait for lookup [%s]", new Object[]{this.extractorID});
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.entry = this.cacheScheduler.schedule(this.extractionNamespace);
                }
                LOG.debug("NamespaceLookupExtractorFactory[%s] started", new Object[]{this.extractorID});
                boolean bl = true;
                return bl;
            }
            finally {
                writeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean close() {
        Lock writeLock = this.startStopSync.writeLock();
        try {
            writeLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.entry == null) {
                LOG.warn("Not started! [%s]", new Object[]{this.extractorID});
                boolean bl = true;
                return bl;
            }
            this.entry.close();
            this.entry = null;
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean replaces(@Nullable LookupExtractorFactory other) {
        if (other != null && other instanceof NamespaceLookupExtractorFactory) {
            NamespaceLookupExtractorFactory that = (NamespaceLookupExtractorFactory)other;
            if (this.isInjective() != ((NamespaceLookupExtractorFactory)other).isInjective()) {
                return true;
            }
            if (this.getFirstCacheTimeout() != ((NamespaceLookupExtractorFactory)other).getFirstCacheTimeout()) {
                return true;
            }
            return !this.extractionNamespace.equals(that.extractionNamespace);
        }
        return true;
    }

    public LookupIntrospectHandler getIntrospectHandler() {
        return this.lookupIntrospectHandler;
    }

    @JsonProperty
    public ExtractionNamespace getExtractionNamespace() {
        return this.extractionNamespace;
    }

    @JsonProperty
    public long getFirstCacheTimeout() {
        return this.firstCacheTimeout;
    }

    @JsonProperty
    public boolean isInjective() {
        return this.injective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupExtractor get() {
        Lock readLock = this.startStopSync.readLock();
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.entry == null) {
                throw new ISE("Factory [%s] not started", new Object[]{this.extractorID});
            }
            CacheScheduler.CacheState cacheState = this.entry.getCacheState();
            if (cacheState instanceof CacheScheduler.NoCache) {
                String noCacheReason = ((CacheScheduler.NoCache)cacheState).name();
                throw new ISE("%s: %s, extractorID = %s", new Object[]{this.entry, noCacheReason, this.extractorID});
            }
            CacheScheduler.VersionedCache versionedCache = (CacheScheduler.VersionedCache)cacheState;
            Map<String, String> map = versionedCache.getCache();
            final byte[] v = StringUtils.toUtf8((String)versionedCache.getVersion());
            final byte[] id = StringUtils.toUtf8((String)this.extractorID);
            MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(map, this.isInjective()){

                public byte[] getCacheKey() {
                    return ByteBuffer.allocate(CLASS_CACHE_KEY.length + id.length + 1 + v.length + 1 + 1).put(CLASS_CACHE_KEY).put(id).put((byte)-1).put(v).put((byte)-1).put(this.isOneToOne() ? (byte)1 : 0).array();
                }
            };
            return mapLookupExtractor;
        }
        finally {
            readLock.unlock();
        }
    }

    @VisibleForTesting
    CacheScheduler getCacheScheduler() {
        return this.cacheScheduler;
    }

    public String toString() {
        return "NamespaceLookupExtractorFactory{extractionNamespace=" + this.extractionNamespace + ", firstCacheTimeout=" + this.firstCacheTimeout + ", injective=" + this.injective + ", extractorID='" + this.extractorID + '\'' + '}';
    }

    static {
        byte[] keyUtf8 = StringUtils.toUtf8((String)NamespaceLookupExtractorFactory.class.getName());
        CLASS_CACHE_KEY = ByteBuffer.allocate(keyUtf8.length + 1).put(keyUtf8).put((byte)-1).array();
    }
}

