/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.storage.mysql;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import java.util.Collections;
import java.util.List;
import org.apache.druid.firehose.sql.MySQLFirehoseDatabaseConnector;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.SQLMetadataStorageDruidModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.metadata.MetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageProvider;
import org.apache.druid.metadata.MySQLMetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.NoopMetadataStorageProvider;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.storage.mysql.MySQLConnector;
import org.apache.druid.metadata.storage.mysql.MySQLConnectorDriverConfig;
import org.apache.druid.metadata.storage.mysql.MySQLConnectorSslConfig;

public class MySQLMetadataStorageModule
extends SQLMetadataStorageDruidModule
implements DruidModule {
    public static final String TYPE = "mysql";

    public MySQLMetadataStorageModule() {
        super(TYPE);
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(MySQLFirehoseDatabaseConnector.class, TYPE)}));
    }

    public void configure(Binder binder) {
        super.configure(binder);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.metadata.mysql.ssl", MySQLConnectorSslConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.metadata.mysql.driver", MySQLConnectorDriverConfig.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(MetadataStorageProvider.class)).addBinding((Object)TYPE).to(NoopMetadataStorageProvider.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(MetadataStorageConnector.class)).addBinding((Object)TYPE).to(MySQLConnector.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(SQLMetadataConnector.class)).addBinding((Object)TYPE).to(MySQLConnector.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(MetadataStorageActionHandlerFactory.class)).addBinding((Object)TYPE).to(MySQLMetadataStorageActionHandlerFactory.class).in(LazySingleton.class);
    }
}

