/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.storage.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.File;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.storage.mysql.MySQLConnectorDriverConfig;
import org.apache.druid.metadata.storage.mysql.MySQLConnectorSslConfig;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class MySQLConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(MySQLConnector.class);
    private static final String PAYLOAD_TYPE = "LONGBLOB";
    private static final String SERIAL_TYPE = "BIGINT(20) AUTO_INCREMENT";
    private static final String QUOTE_STRING = "`";
    private static final String COLLATION = "CHARACTER SET utf8mb4 COLLATE utf8mb4_bin";
    private static final String MYSQL_TRANSIENT_EXCEPTION_CLASS_NAME = "com.mysql.jdbc.exceptions.MySQLTransientException";
    @Nullable
    private final Class<?> myTransientExceptionClass;
    private final DBI dbi;

    @Inject
    public MySQLConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, MySQLConnectorSslConfig connectorSslConfig, MySQLConnectorDriverConfig driverConfig) {
        super(config, dbTables);
        log.info("Loading MySQL metadata connector driver %s", new Object[]{driverConfig.getDriverClassName()});
        this.tryLoadDriverClass(driverConfig.getDriverClassName(), true);
        this.myTransientExceptionClass = driverConfig.getDriverClassName().contains("mysql") ? this.tryLoadDriverClass(MYSQL_TRANSIENT_EXCEPTION_CLASS_NAME, false) : null;
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        datasource.setDriverClassName(driverConfig.getDriverClassName());
        datasource.addConnectionProperty("useSSL", String.valueOf(connectorSslConfig.isUseSSL()));
        if (connectorSslConfig.isUseSSL()) {
            log.info("SSL is enabled on this MySQL connection. ", new Object[0]);
            datasource.addConnectionProperty("verifyServerCertificate", String.valueOf(connectorSslConfig.isVerifyServerCertificate()));
            if (connectorSslConfig.isVerifyServerCertificate()) {
                log.info("Server certificate verification is enabled. ", new Object[0]);
                if (connectorSslConfig.getTrustCertificateKeyStoreUrl() != null) {
                    datasource.addConnectionProperty("trustCertificateKeyStoreUrl", new File(connectorSslConfig.getTrustCertificateKeyStoreUrl()).toURI().toString());
                }
                if (connectorSslConfig.getTrustCertificateKeyStoreType() != null) {
                    datasource.addConnectionProperty("trustCertificateKeyStoreType", connectorSslConfig.getTrustCertificateKeyStoreType());
                }
                if (connectorSslConfig.getTrustCertificateKeyStorePassword() == null) {
                    log.warn("Trust store password is empty. Ensure that the trust store has been configured with an empty password.", new Object[0]);
                } else {
                    datasource.addConnectionProperty("trustCertificateKeyStorePassword", connectorSslConfig.getTrustCertificateKeyStorePassword());
                }
            }
            if (connectorSslConfig.getClientCertificateKeyStoreUrl() != null) {
                datasource.addConnectionProperty("clientCertificateKeyStoreUrl", new File(connectorSslConfig.getClientCertificateKeyStoreUrl()).toURI().toString());
            }
            if (connectorSslConfig.getClientCertificateKeyStoreType() != null) {
                datasource.addConnectionProperty("clientCertificateKeyStoreType", connectorSslConfig.getClientCertificateKeyStoreType());
            }
            if (connectorSslConfig.getClientCertificateKeyStorePassword() != null) {
                datasource.addConnectionProperty("clientCertificateKeyStorePassword", connectorSslConfig.getClientCertificateKeyStorePassword());
            }
            Joiner joiner = Joiner.on((String)",").skipNulls();
            if (connectorSslConfig.getEnabledSSLCipherSuites() != null) {
                datasource.addConnectionProperty("enabledSSLCipherSuites", joiner.join(connectorSslConfig.getEnabledSSLCipherSuites()));
            }
            if (connectorSslConfig.getEnabledTLSProtocols() != null) {
                datasource.addConnectionProperty("enabledTLSProtocols", joiner.join(connectorSslConfig.getEnabledTLSProtocols()));
            }
        }
        datasource.setConnectionInitSqls((Collection)ImmutableList.of((Object)"SET sql_mode='ANSI_QUOTES'"));
        this.dbi = new DBI((DataSource)datasource);
        log.info("Configured MySQL as metadata storage", new Object[0]);
    }

    public String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    public String getSerialType() {
        return SERIAL_TYPE;
    }

    public String getCollation() {
        return COLLATION;
    }

    public String getQuoteString() {
        return QUOTE_STRING;
    }

    public int getStreamingFetchSize() {
        return Integer.MIN_VALUE;
    }

    public String limitClause(int limit) {
        return String.format(Locale.ENGLISH, "LIMIT %d", limit);
    }

    public boolean tableExists(Handle handle, String tableName) {
        String databaseCharset = (String)handle.createQuery("SELECT @@character_set_database").map((ResultSetMapper)StringMapper.FIRST).first();
        if (!databaseCharset.startsWith("utf8")) {
            throw new ISE("Druid requires its MySQL database to be created with an UTF8 charset, found `%1$s`. The recommended charset is `utf8mb4`.", new Object[]{databaseCharset});
        }
        if (!"utf8mb4".equals(databaseCharset)) {
            log.warn("The current database charset `%1$s` does not match the recommended charset `utf8mb4`", new Object[]{databaseCharset});
        }
        return !((Query)handle.createQuery("SHOW tables LIKE :tableName").bind("tableName", tableName)).list().isEmpty();
    }

    protected boolean connectorIsTransientException(Throwable e) {
        if (this.myTransientExceptionClass != null) {
            return this.myTransientExceptionClass.isAssignableFrom(e.getClass()) || e instanceof SQLException && ((SQLException)e).getErrorCode() == 1317;
        }
        return false;
    }

    public Void insertOrUpdate(String tableName, String keyColumn, String valueColumn, String key, byte[] value) {
        return (Void)this.getDBI().withHandle(handle -> {
            ((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value) ON DUPLICATE KEY UPDATE %3$s = :value", (Object[])new Object[]{tableName, keyColumn, valueColumn})).bind("key", key)).bind("value", value)).execute();
            return null;
        });
    }

    public DBI getDBI() {
        return this.dbi;
    }

    @Nullable
    private Class<?> tryLoadDriverClass(String className, boolean failIfNotFound) {
        try {
            return Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (failIfNotFound) {
                throw new ISE((Throwable)e, "Could not find %s on the classpath. The MySQL Connector library is not included in the Druid distribution but is required to use MySQL. Please download a compatible library (for example 'mysql-connector-java-5.1.49.jar') and place it under 'extensions/mysql-metadata-storage/'. See https://druid.apache.org/downloads for more details.", new Object[]{className});
            }
            log.warn("Could not find %s on the classpath.", new Object[]{className});
            return null;
        }
    }
}

