/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.apache.druid.utils.ConnectionUriUtils;
import org.skife.jdbi.v2.DBI;

@JsonTypeName(value="postgresql")
public class PostgresqlFirehoseDatabaseConnector
extends SQLFirehoseDatabaseConnector {
    private final DBI dbi;
    private final MetadataStorageConnectorConfig connectorConfig;

    @JsonCreator
    public PostgresqlFirehoseDatabaseConnector(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig connectorConfig, @JacksonInject JdbcAccessSecurityConfig securityConfig) {
        this.connectorConfig = connectorConfig;
        BasicDataSource datasource = this.getDatasource(connectorConfig, securityConfig);
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        datasource.setDriverClassName("org.postgresql.Driver");
        this.dbi = new DBI((DataSource)datasource);
    }

    @JsonProperty
    public MetadataStorageConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public DBI getDBI() {
        return this.dbi;
    }

    public Set<String> findPropertyKeysFromConnectURL(String connectUri, boolean allowUnknown) {
        return ConnectionUriUtils.tryParseJdbcUriParameters((String)connectUri, (boolean)allowUnknown);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PostgresqlFirehoseDatabaseConnector that = (PostgresqlFirehoseDatabaseConnector)((Object)o);
        return this.connectorConfig.equals((Object)that.connectorConfig);
    }

    public int hashCode() {
        return Objects.hash(this.connectorConfig);
    }

    public String toString() {
        return "PostgresqlFirehoseDatabaseConnector{connectorConfig=" + this.connectorConfig + '}';
    }
}

