/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.jdbc;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaPreparedStatement;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchConnectionException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.jdbc.JdbcResultSet;
import org.apache.calcite.avatica.jdbc.StatementInfo;
import org.apache.calcite.avatica.metrics.Gauge;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.proto.Requests;
import org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.calcite.avatica.remote.ProtobufMeta;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.avatica.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMeta
implements ProtobufMeta {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcMeta.class);
    private static final String CONN_CACHE_KEY_BASE = "avatica.connectioncache";
    private static final String STMT_CACHE_KEY_BASE = "avatica.statementcache";
    public static final int UNLIMITED_COUNT = -2;
    final Calendar calendar = Unsafe.localCalendar();
    private final AtomicInteger statementIdGenerator = new AtomicInteger();
    private final String url;
    private final Properties info;
    private final Cache<String, Connection> connectionCache;
    private final Cache<Integer, StatementInfo> statementCache;
    private final MetricsSystem metrics;

    public JdbcMeta(String url) throws SQLException {
        this(url, new Properties());
    }

    public JdbcMeta(String url, final String user, final String password) throws SQLException {
        this(url, new Properties(){
            {
                this.put("user", user);
                this.put("password", password);
            }
        });
    }

    public JdbcMeta(String url, Properties info) throws SQLException {
        this(url, info, (MetricsSystem)NoopMetricsSystem.getInstance());
    }

    public JdbcMeta(String url, Properties info, MetricsSystem metrics) throws SQLException {
        this.url = url;
        this.info = info;
        this.metrics = Objects.requireNonNull(metrics);
        int concurrencyLevel = Integer.parseInt(info.getProperty(ConnectionCacheSettings.CONCURRENCY_LEVEL.key(), ConnectionCacheSettings.CONCURRENCY_LEVEL.defaultValue()));
        int initialCapacity = Integer.parseInt(info.getProperty(ConnectionCacheSettings.INITIAL_CAPACITY.key(), ConnectionCacheSettings.INITIAL_CAPACITY.defaultValue()));
        long maxCapacity = Long.parseLong(info.getProperty(ConnectionCacheSettings.MAX_CAPACITY.key(), ConnectionCacheSettings.MAX_CAPACITY.defaultValue()));
        long connectionExpiryDuration = Long.parseLong(info.getProperty(ConnectionCacheSettings.EXPIRY_DURATION.key(), ConnectionCacheSettings.EXPIRY_DURATION.defaultValue()));
        TimeUnit connectionExpiryUnit = TimeUnit.valueOf(info.getProperty(ConnectionCacheSettings.EXPIRY_UNIT.key(), ConnectionCacheSettings.EXPIRY_UNIT.defaultValue()));
        this.connectionCache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maxCapacity).expireAfterAccess(connectionExpiryDuration, connectionExpiryUnit).removalListener((RemovalListener)new ConnectionExpiryHandler()).build();
        LOG.debug("instantiated connection cache: {}", (Object)this.connectionCache.stats());
        concurrencyLevel = Integer.parseInt(info.getProperty(StatementCacheSettings.CONCURRENCY_LEVEL.key(), StatementCacheSettings.CONCURRENCY_LEVEL.defaultValue()));
        initialCapacity = Integer.parseInt(info.getProperty(StatementCacheSettings.INITIAL_CAPACITY.key(), StatementCacheSettings.INITIAL_CAPACITY.defaultValue()));
        maxCapacity = Long.parseLong(info.getProperty(StatementCacheSettings.MAX_CAPACITY.key(), StatementCacheSettings.MAX_CAPACITY.defaultValue()));
        connectionExpiryDuration = Long.parseLong(info.getProperty(StatementCacheSettings.EXPIRY_DURATION.key(), StatementCacheSettings.EXPIRY_DURATION.defaultValue()));
        connectionExpiryUnit = TimeUnit.valueOf(info.getProperty(StatementCacheSettings.EXPIRY_UNIT.key(), StatementCacheSettings.EXPIRY_UNIT.defaultValue()));
        this.statementCache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maxCapacity).expireAfterAccess(connectionExpiryDuration, connectionExpiryUnit).removalListener((RemovalListener)new StatementExpiryHandler()).build();
        LOG.debug("instantiated statement cache: {}", (Object)this.statementCache.stats());
        this.metrics.register(MetricsHelper.concat(JdbcMeta.class, (String)"ConnectionCacheSize"), (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return JdbcMeta.this.connectionCache.size();
            }
        });
        this.metrics.register(MetricsHelper.concat(JdbcMeta.class, (String)"StatementCacheSize"), (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return JdbcMeta.this.statementCache.size();
            }
        });
    }

    protected AtomicInteger getStatementIdGenerator() {
        return this.statementIdGenerator;
    }

    protected Cache<String, Connection> getConnectionCache() {
        return this.connectionCache;
    }

    protected Cache<Integer, StatementInfo> getStatementCache() {
        return this.statementCache;
    }

    protected static List<ColumnMetaData> columns(ResultSetMetaData metaData) throws SQLException {
        if (metaData == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            ColumnMetaData.ArrayType t;
            SqlType sqlType = SqlType.valueOf((int)metaData.getColumnType(i));
            ColumnMetaData.Rep rep = ColumnMetaData.Rep.of((Type)sqlType.internal);
            if (sqlType == SqlType.ARRAY || sqlType == SqlType.STRUCT || sqlType == SqlType.MULTISET) {
                ColumnMetaData.ScalarType arrayValueType = ColumnMetaData.scalar((int)2000, (String)metaData.getColumnTypeName(i), (ColumnMetaData.Rep)ColumnMetaData.Rep.OBJECT);
                t = ColumnMetaData.array((ColumnMetaData.AvaticaType)arrayValueType, (String)metaData.getColumnTypeName(i), (ColumnMetaData.Rep)rep);
            } else {
                t = ColumnMetaData.scalar((int)metaData.getColumnType(i), (String)metaData.getColumnTypeName(i), (ColumnMetaData.Rep)rep);
            }
            ColumnMetaData md = new ColumnMetaData(i - 1, metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), metaData.isSearchable(i), metaData.isCurrency(i), metaData.isNullable(i), metaData.isSigned(i), metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), metaData.getSchemaName(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getTableName(i), metaData.getCatalogName(i), (ColumnMetaData.AvaticaType)t, metaData.isReadOnly(i), metaData.isWritable(i), metaData.isDefinitelyWritable(i), metaData.getColumnClassName(i));
            columns.add(md);
        }
        return columns;
    }

    protected static List<AvaticaParameter> parameters(ParameterMetaData metaData) throws SQLException {
        if (metaData == null) {
            return Collections.emptyList();
        }
        ArrayList<AvaticaParameter> params = new ArrayList<AvaticaParameter>();
        for (int i = 1; i <= metaData.getParameterCount(); ++i) {
            params.add(new AvaticaParameter(metaData.isSigned(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getParameterType(i), metaData.getParameterTypeName(i), metaData.getParameterClassName(i), "?" + i));
        }
        return params;
    }

    protected static Meta.Signature signature(ResultSetMetaData metaData, ParameterMetaData parameterMetaData, String sql, Meta.StatementType statementType) throws SQLException {
        Meta.CursorFactory cf = Meta.CursorFactory.LIST;
        return new Meta.Signature(JdbcMeta.columns(metaData), sql, JdbcMeta.parameters(parameterMetaData), null, cf, statementType);
    }

    protected static Meta.Signature signature(ResultSetMetaData metaData) throws SQLException {
        return JdbcMeta.signature(metaData, null, null, null);
    }

    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties(Meta.ConnectionHandle ch) {
        try {
            HashMap<Meta.DatabaseProperty, Object> map = new HashMap<Meta.DatabaseProperty, Object>();
            Connection conn = this.getConnection(ch.id);
            DatabaseMetaData metaData = conn.getMetaData();
            for (Meta.DatabaseProperty p : Meta.DatabaseProperty.values()) {
                JdbcMeta.addProperty(map, metaData, p);
            }
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object addProperty(Map<Meta.DatabaseProperty, Object> map, DatabaseMetaData metaData, Meta.DatabaseProperty p) throws SQLException {
        Object propertyValue;
        if (p.isJdbc) {
            try {
                propertyValue = p.method.invoke((Object)metaData, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            propertyValue = p.defaultValue;
        }
        return map.put(p, propertyValue);
    }

    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getTables(catalog, schemaPattern.s, tableNamePattern.s, JdbcMeta.toArray(typeList));
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int registerMetaStatement(ResultSet rs) throws SQLException {
        int id = this.statementIdGenerator.getAndIncrement();
        StatementInfo statementInfo = new StatementInfo(rs.getStatement());
        statementInfo.setResultSet(rs);
        this.statementCache.put((Object)id, (Object)statementInfo);
        return id;
    }

    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getColumns(catalog, schemaPattern.s, tableNamePattern.s, columnNamePattern.s);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getSchemas(catalog, schemaPattern.s);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getCatalogs();
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getTableTypes(Meta.ConnectionHandle ch) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getTableTypes();
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getProcedures(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getProcedures(catalog, schemaPattern.s, procedureNamePattern.s);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getProcedureColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getProcedureColumns(catalog, schemaPattern.s, procedureNamePattern.s, columnNamePattern.s);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getColumnPrivileges(Meta.ConnectionHandle ch, String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getColumnPrivileges(catalog, schema, table, columnNamePattern.s);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getTablePrivileges(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getTablePrivileges(catalog, schemaPattern.s, tableNamePattern.s);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getBestRowIdentifier(Meta.ConnectionHandle ch, String catalog, String schema, String table, int scope, boolean nullable) {
        LOG.trace("getBestRowIdentifier catalog:{} schema:{} table:{} scope:{} nullable:{}", new Object[]{catalog, schema, table, scope, nullable});
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getBestRowIdentifier(catalog, schema, table, scope, nullable);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getVersionColumns(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        LOG.trace("getVersionColumns catalog:{} schema:{} table:{}", new Object[]{catalog, schema, table});
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getVersionColumns(catalog, schema, table);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getPrimaryKeys(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        LOG.trace("getPrimaryKeys catalog:{} schema:{} table:{}", new Object[]{catalog, schema, table});
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getPrimaryKeys(catalog, schema, table);
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getImportedKeys(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        return null;
    }

    public Meta.MetaResultSet getExportedKeys(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        return null;
    }

    public Meta.MetaResultSet getCrossReference(Meta.ConnectionHandle ch, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return null;
    }

    public Meta.MetaResultSet getTypeInfo(Meta.ConnectionHandle ch) {
        try {
            ResultSet rs = this.getConnection(ch.id).getMetaData().getTypeInfo();
            int stmtId = this.registerMetaStatement(rs);
            return JdbcResultSet.create(ch.id, stmtId, rs);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getIndexInfo(Meta.ConnectionHandle ch, String catalog, String schema, String table, boolean unique, boolean approximate) {
        return null;
    }

    public Meta.MetaResultSet getUDTs(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return null;
    }

    public Meta.MetaResultSet getSuperTypes(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getSuperTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getAttributes(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getClientInfoProperties(Meta.ConnectionHandle ch) {
        return null;
    }

    public Meta.MetaResultSet getFunctions(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getFunctionColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getPseudoColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return null;
    }

    public Iterable<Object> createIterable(Meta.StatementHandle handle, QueryState state, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        return null;
    }

    protected Connection getConnection(String id) throws SQLException {
        if (id == null) {
            throw new NullPointerException("Connection id is null.");
        }
        Connection conn = (Connection)this.connectionCache.getIfPresent((Object)id);
        if (conn == null) {
            throw new NoSuchConnectionException("Connection not found: invalid id, closed, or expired: " + id);
        }
        return conn;
    }

    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        try {
            Connection conn = this.getConnection(ch.id);
            Statement statement = conn.createStatement();
            int id = this.statementIdGenerator.getAndIncrement();
            this.statementCache.put((Object)id, (Object)new StatementInfo(statement));
            Meta.StatementHandle h = new Meta.StatementHandle(ch.id, id, null);
            LOG.trace("created statement {}", (Object)h);
            return h;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public void closeStatement(Meta.StatementHandle h) {
        StatementInfo info = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
        if (info == null || info.statement == null) {
            LOG.debug("client requested close unknown statement {}", (Object)h);
            return;
        }
        LOG.trace("closing statement {}", (Object)h);
        try {
            ResultSet results = info.getResultSet();
            if (info.isResultSetInitialized() && null != results) {
                results.close();
            }
            info.statement.close();
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
        finally {
            this.statementCache.invalidate((Object)h.id);
        }
    }

    public void openConnection(Meta.ConnectionHandle ch, Map<String, String> info) {
        ConcurrentMap cacheAsMap;
        Properties fullInfo = new Properties();
        fullInfo.putAll((Map<?, ?>)this.info);
        if (info != null) {
            fullInfo.putAll(info);
        }
        if ((cacheAsMap = this.connectionCache.asMap()).containsKey(ch.id)) {
            throw new RuntimeException("Connection already exists: " + ch.id);
        }
        try {
            Connection conn = this.createConnection(this.url, fullInfo);
            Connection loadedConn = cacheAsMap.putIfAbsent(ch.id, conn);
            if (loadedConn != null) {
                conn.close();
                throw new RuntimeException("Connection already exists: " + ch.id);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Connection createConnection(String url, Properties info) throws SQLException {
        return DriverManager.getConnection(url, info);
    }

    public void closeConnection(Meta.ConnectionHandle ch) {
        Connection conn = (Connection)this.connectionCache.getIfPresent((Object)ch.id);
        if (conn == null) {
            LOG.debug("client requested close unknown connection {}", (Object)ch);
            return;
        }
        LOG.trace("closing connection {}", (Object)ch);
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
        finally {
            this.connectionCache.invalidate((Object)ch.id);
        }
    }

    protected void apply(Connection conn, Meta.ConnectionProperties connProps) throws SQLException {
        if (connProps.isAutoCommit() != null) {
            conn.setAutoCommit(connProps.isAutoCommit());
        }
        if (connProps.isReadOnly() != null) {
            conn.setReadOnly(connProps.isReadOnly());
        }
        if (connProps.getTransactionIsolation() != null) {
            conn.setTransactionIsolation(connProps.getTransactionIsolation());
        }
        if (connProps.getCatalog() != null) {
            conn.setCatalog(connProps.getCatalog());
        }
        if (connProps.getSchema() != null) {
            conn.setSchema(connProps.getSchema());
        }
    }

    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        LOG.trace("syncing properties for connection {}", (Object)ch);
        try {
            Connection conn = this.getConnection(ch.id);
            ConnectionPropertiesImpl props = new ConnectionPropertiesImpl(conn).merge(connProps);
            if (props.isDirty()) {
                this.apply(conn, (Meta.ConnectionProperties)props);
                props.setDirty(false);
            }
            return props;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    RuntimeException propagate(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        try {
            Connection conn = this.getConnection(ch.id);
            PreparedStatement statement = conn.prepareStatement(sql);
            int id = this.getStatementIdGenerator().getAndIncrement();
            Meta.StatementType statementType = null;
            if (statement.isWrapperFor(AvaticaPreparedStatement.class)) {
                AvaticaPreparedStatement avaticaPreparedStatement = statement.unwrap(AvaticaPreparedStatement.class);
                statementType = avaticaPreparedStatement.getStatementType();
            }
            this.setMaxRows(statement, maxRowCount);
            this.getStatementCache().put((Object)id, (Object)new StatementInfo(statement));
            Meta.StatementHandle h = new Meta.StatementHandle(ch.id, id, JdbcMeta.signature(statement.getMetaData(), statement.getParameterMetaData(), sql, statementType));
            LOG.trace("prepared statement {}", (Object)h);
            return h;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, Meta.PrepareCallback callback) throws NoSuchStatementException {
        return this.prepareAndExecute(h, sql, maxRowCount, AvaticaUtils.toSaturatedInt((long)maxRowCount), callback);
    }

    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        try {
            StatementInfo info = (StatementInfo)this.getStatementCache().getIfPresent((Object)h.id);
            if (info == null) {
                throw new NoSuchStatementException(h);
            }
            Statement statement = info.statement;
            this.setMaxRows(statement, maxRowCount);
            boolean ret = statement.execute(sql);
            info.setResultSet(statement.getResultSet());
            assert (ret || null == info.getResultSet());
            ArrayList<Meta.MetaResultSet> resultSets = new ArrayList<Meta.MetaResultSet>();
            if (null == info.getResultSet()) {
                resultSets.add(JdbcResultSet.count((String)h.connectionId, (int)h.id, (long)AvaticaUtils.getLargeUpdateCount((Statement)statement)));
            } else {
                resultSets.add(JdbcResultSet.create(h.connectionId, h.id, info.getResultSet(), maxRowsInFirstFrame));
            }
            LOG.trace("prepAndExec statement {}", (Object)h);
            return new Meta.ExecuteResult(resultSets);
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    void setMaxRows(Statement statement, long maxRowCount) throws SQLException {
        if (maxRowCount > 0L) {
            AvaticaUtils.setLargeMaxRows((Statement)statement, (long)maxRowCount);
        } else if (maxRowCount < 0L) {
            statement.setMaxRows(0);
        }
    }

    public boolean syncResults(Meta.StatementHandle sh, QueryState state, long offset) throws NoSuchStatementException {
        try {
            Connection conn = this.getConnection(sh.connectionId);
            StatementInfo info = (StatementInfo)this.statementCache.getIfPresent((Object)sh.id);
            if (null == info) {
                throw new NoSuchStatementException(sh);
            }
            Statement statement = info.statement;
            info.setResultSet(state.invoke(conn, statement));
            if (null != info.getResultSet()) {
                return info.advanceResultSetToOffset(info.getResultSet(), offset);
            }
            return false;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.Frame fetch(Meta.StatementHandle h, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        LOG.trace("fetching {} offset:{} fetchMaxRowCount:{}", new Object[]{h, offset, fetchMaxRowCount});
        try {
            StatementInfo statementInfo = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
            if (null == statementInfo) {
                throw new NoSuchStatementException(h);
            }
            if (!statementInfo.isResultSetInitialized()) {
                throw new MissingResultsException(h);
            }
            if (statementInfo.getResultSet() == null) {
                return Meta.Frame.EMPTY;
            }
            return JdbcResultSet.frame(statementInfo, statementInfo.getResultSet(), offset, fetchMaxRowCount, this.calendar, (Optional<Meta.Signature>)Optional.absent());
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    private static String[] toArray(List<String> typeList) {
        if (typeList == null) {
            return null;
        }
        return typeList.toArray(new String[typeList.size()]);
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle h, List<TypedValue> parameterValues, long maxRowCount) throws NoSuchStatementException {
        return this.execute(h, parameterValues, AvaticaUtils.toSaturatedInt((long)maxRowCount));
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle h, List<TypedValue> parameterValues, int maxRowsInFirstFrame) throws NoSuchStatementException {
        try {
            List<JdbcResultSet> resultSets;
            if (MetaImpl.checkParameterValueHasNull(parameterValues)) {
                throw new SQLException("exception while executing query: unbound parameter");
            }
            StatementInfo statementInfo = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
            if (null == statementInfo) {
                throw new NoSuchStatementException(h);
            }
            PreparedStatement preparedStatement = (PreparedStatement)statementInfo.statement;
            if (parameterValues != null) {
                for (int i = 0; i < parameterValues.size(); ++i) {
                    TypedValue o = parameterValues.get(i);
                    preparedStatement.setObject(i + 1, o.toJdbc(this.calendar));
                }
            }
            if (preparedStatement.execute()) {
                Meta.Signature signature2 = preparedStatement.isWrapperFor(AvaticaPreparedStatement.class) ? h.signature : (h.signature = JdbcMeta.signature(preparedStatement.getMetaData(), preparedStatement.getParameterMetaData(), h.signature.sql, Meta.StatementType.SELECT));
                statementInfo.setResultSet(preparedStatement.getResultSet());
                resultSets = statementInfo.getResultSet() == null ? Collections.singletonList(JdbcResultSet.empty(h.connectionId, h.id, signature2)) : Collections.singletonList(JdbcResultSet.create(h.connectionId, h.id, statementInfo.getResultSet(), maxRowsInFirstFrame, signature2));
            } else {
                resultSets = Collections.singletonList(JdbcResultSet.count(h.connectionId, h.id, preparedStatement.getUpdateCount()));
            }
            return new Meta.ExecuteResult(resultSets);
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public void commit(Meta.ConnectionHandle ch) {
        try {
            Connection conn = this.getConnection(ch.id);
            conn.commit();
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public void rollback(Meta.ConnectionHandle ch) {
        try {
            Connection conn = this.getConnection(ch.id);
            conn.rollback();
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle h, List<String> sqlCommands) throws NoSuchStatementException {
        try {
            StatementInfo info = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
            if (info == null) {
                throw new NoSuchStatementException(h);
            }
            Statement stmt = info.statement;
            for (String sqlCommand : sqlCommands) {
                stmt.addBatch(sqlCommand);
            }
            return new Meta.ExecuteBatchResult(AvaticaUtils.executeLargeBatch((Statement)stmt));
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle h, List<List<TypedValue>> updateBatches) throws NoSuchStatementException {
        try {
            StatementInfo info = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
            if (null == info) {
                throw new NoSuchStatementException(h);
            }
            PreparedStatement preparedStmt = (PreparedStatement)info.statement;
            int rowUpdate = 1;
            for (List<TypedValue> batch : updateBatches) {
                int i = 1;
                for (TypedValue value : batch) {
                    try {
                        preparedStmt.setObject(i, value.toJdbc(this.calendar));
                        ++i;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Failed to set value on row #" + rowUpdate + " and column #" + i, e);
                    }
                    ++rowUpdate;
                }
                preparedStmt.addBatch();
            }
            return new Meta.ExecuteBatchResult(AvaticaUtils.executeLargeBatch((Statement)preparedStmt));
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.ExecuteBatchResult executeBatchProtobuf(Meta.StatementHandle h, List<Requests.UpdateBatch> updateBatches) throws NoSuchStatementException {
        try {
            StatementInfo info = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
            if (null == info) {
                throw new NoSuchStatementException(h);
            }
            PreparedStatement preparedStmt = (PreparedStatement)info.statement;
            for (Requests.UpdateBatch update : updateBatches) {
                int i = 1;
                for (Common.TypedValue value : update.getParameterValuesList()) {
                    preparedStmt.setObject(i++, TypedValue.protoToJdbc((Common.TypedValue)value, (Calendar)this.calendar));
                }
                preparedStmt.addBatch();
            }
            return new Meta.ExecuteBatchResult(AvaticaUtils.executeLargeBatch((Statement)preparedStmt));
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    private class StatementExpiryHandler
    implements RemovalListener<Integer, StatementInfo> {
        private StatementExpiryHandler() {
        }

        public void onRemoval(RemovalNotification<Integer, StatementInfo> notification) {
            Integer stmtId = (Integer)notification.getKey();
            StatementInfo doomed = (StatementInfo)notification.getValue();
            if (doomed == null) {
                return;
            }
            LOG.debug("Expiring statement {} because {}", (Object)stmtId, (Object)notification.getCause());
            try {
                if (doomed.getResultSet() != null) {
                    doomed.getResultSet().close();
                }
                if (doomed.statement != null) {
                    doomed.statement.close();
                }
            }
            catch (Throwable t) {
                LOG.info("Exception thrown while expiring statement {}", (Object)stmtId, (Object)t);
            }
        }
    }

    private class ConnectionExpiryHandler
    implements RemovalListener<String, Connection> {
        private ConnectionExpiryHandler() {
        }

        public void onRemoval(RemovalNotification<String, Connection> notification) {
            String connectionId = (String)notification.getKey();
            Connection doomed = (Connection)notification.getValue();
            LOG.debug("Expiring connection {} because {}", (Object)connectionId, (Object)notification.getCause());
            try {
                if (doomed != null) {
                    doomed.close();
                }
            }
            catch (Throwable t) {
                LOG.info("Exception thrown while expiring connection {}", (Object)connectionId, (Object)t);
            }
        }
    }

    public static enum ConnectionCacheSettings {
        CONCURRENCY_LEVEL("avatica.connectioncache.concurrency", "10"),
        INITIAL_CAPACITY("avatica.connectioncache.initialcapacity", "100"),
        MAX_CAPACITY("avatica.connectioncache.maxcapacity", "1000"),
        EXPIRY_DURATION("avatica.connectioncache.expiryduration", "10"),
        EXPIRY_UNIT("avatica.connectioncache.expiryunit", TimeUnit.MINUTES.name());

        private final String key;
        private final String defaultValue;

        private ConnectionCacheSettings(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.key;
        }

        public String defaultValue() {
            return this.defaultValue;
        }
    }

    public static enum StatementCacheSettings {
        CONCURRENCY_LEVEL("avatica.statementcache.concurrency", "100"),
        INITIAL_CAPACITY("avatica.statementcache.initialcapacity", "1000"),
        MAX_CAPACITY("avatica.statementcache.maxcapacity", "10000"),
        EXPIRY_DURATION("avatica.statementcache.expiryduration", "5"),
        EXPIRY_UNIT("avatica.statementcache.expiryunit", TimeUnit.MINUTES.name());

        private final String key;
        private final String defaultValue;

        private StatementCacheSettings(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.key;
        }

        public String defaultValue() {
            return this.defaultValue;
        }
    }
}

