/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.parquet.simple.ParquetGroupFlattenerMaker;
import org.apache.druid.data.input.parquet.simple.ParquetParseSpec;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.parquet.example.data.Group;

public class ParquetHadoopInputRowParser
implements InputRowParser<Group> {
    private final ParseSpec parseSpec;
    private final boolean binaryAsString;
    private final ObjectFlattener<Group> groupFlattener;
    private final MapInputRowParser parser;

    @JsonCreator
    public ParquetHadoopInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="binaryAsString") Boolean binaryAsString) {
        this.parseSpec = parseSpec;
        this.binaryAsString = binaryAsString == null ? false : binaryAsString;
        JSONPathSpec flattenSpec = parseSpec instanceof ParquetParseSpec ? (JSONPathSpec)((ParquetParseSpec)parseSpec).getFlattenSpec() : JSONPathSpec.DEFAULT;
        this.groupFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new ParquetGroupFlattenerMaker(this.binaryAsString));
        this.parser = new MapInputRowParser(parseSpec);
    }

    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new ParquetHadoopInputRowParser(parseSpec, this.binaryAsString);
    }

    public List<InputRow> parseBatch(Group group) {
        return this.parser.parseBatch(this.groupFlattener.flatten((Object)group));
    }
}

