/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.joda.time.Duration;
import org.joda.time.Period;

class ParquetGroupConverter {
    private static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private final boolean binaryAsString;

    @Nullable
    private static Object convertField(Group g, String fieldName, boolean binaryAsString) {
        if (!g.getType().containsField(fieldName)) {
            return null;
        }
        int fieldIndex = g.getType().getFieldIndex(fieldName);
        if (g.getFieldRepetitionCount(fieldIndex) <= 0) {
            return null;
        }
        Type fieldType = (Type)g.getType().getFields().get(fieldIndex);
        if (fieldType.isPrimitive()) {
            if (fieldType.getRepetition().equals((Object)Type.Repetition.REPEATED)) {
                int repeated = g.getFieldRepetitionCount(fieldIndex);
                ArrayList<Object> vals = new ArrayList<Object>();
                for (int i = 0; i < repeated; ++i) {
                    vals.add(ParquetGroupConverter.convertPrimitiveField(g, fieldIndex, i, binaryAsString));
                }
                return vals;
            }
            return ParquetGroupConverter.convertPrimitiveField(g, fieldIndex, binaryAsString);
        }
        if (fieldType.isRepetition(Type.Repetition.REPEATED)) {
            return ParquetGroupConverter.convertRepeatedFieldToList(g, fieldIndex, binaryAsString);
        }
        if (ParquetGroupConverter.isLogicalMapType(fieldType)) {
            return ParquetGroupConverter.convertLogicalMap(g.getGroup(fieldIndex, 0), binaryAsString);
        }
        if (ParquetGroupConverter.isLogicalListType(fieldType)) {
            return ParquetGroupConverter.convertLogicalList(g.getGroup(fieldIndex, 0), binaryAsString);
        }
        return g.getGroup(fieldIndex, 0);
    }

    private static List<Object> convertRepeatedFieldToList(Group g, int fieldIndex, boolean binaryAsString) {
        Type t = (Type)g.getType().getFields().get(fieldIndex);
        assert (t.getRepetition().equals((Object)Type.Repetition.REPEATED));
        int repeated = g.getFieldRepetitionCount(fieldIndex);
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int i = 0; i < repeated; ++i) {
            if (t.isPrimitive()) {
                vals.add(ParquetGroupConverter.convertPrimitiveField(g, fieldIndex, i, binaryAsString));
                continue;
            }
            vals.add(g.getGroup(fieldIndex, i));
        }
        return vals;
    }

    private static boolean isLogicalListType(Type listType) {
        return !listType.isPrimitive() && listType.getOriginalType() != null && listType.getOriginalType().equals((Object)OriginalType.LIST) && listType.asGroupType().getFieldCount() == 1 && ((Type)listType.asGroupType().getFields().get(0)).isRepetition(Type.Repetition.REPEATED);
    }

    private static List<Object> convertLogicalList(Group g, boolean binaryAsString) {
        assert (ParquetGroupConverter.isLogicalListType((Type)g.getType()));
        int repeated = g.getFieldRepetitionCount(0);
        boolean isListItemPrimitive = ((Type)g.getType().getFields().get(0)).isPrimitive();
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int i = 0; i < repeated; ++i) {
            if (isListItemPrimitive) {
                vals.add(ParquetGroupConverter.convertPrimitiveField(g, 0, i, binaryAsString));
                continue;
            }
            Group listItem = g.getGroup(0, i);
            vals.add(ParquetGroupConverter.convertListElement(listItem, binaryAsString));
        }
        return vals;
    }

    private static Object convertListElement(Group listItem, boolean binaryAsString) {
        if (listItem.getType().isRepetition(Type.Repetition.REPEATED) && listItem.getType().getFieldCount() == 1 && !listItem.getType().isPrimitive() && ((Type)listItem.getType().getFields().get(0)).isPrimitive()) {
            return ParquetGroupConverter.convertPrimitiveField(listItem, 0, binaryAsString);
        }
        if (listItem.getType().isRepetition(Type.Repetition.REPEATED) && listItem.getType().getFieldCount() == 1 && listItem.getFieldRepetitionCount(0) == 1 && listItem.getType().getName().equalsIgnoreCase("list") && listItem.getType().getFieldName(0).equalsIgnoreCase("element") && listItem.getGroup(0, 0).getType().isRepetition(Type.Repetition.OPTIONAL)) {
            return listItem.getGroup(0, 0);
        }
        return listItem;
    }

    private static boolean isLogicalMapType(Type groupType) {
        OriginalType ot = groupType.getOriginalType();
        if (groupType.isPrimitive() || ot == null || groupType.isRepetition(Type.Repetition.REPEATED)) {
            return false;
        }
        if (groupType.getOriginalType().equals((Object)OriginalType.MAP) || groupType.getOriginalType().equals((Object)OriginalType.MAP_KEY_VALUE)) {
            GroupType myMapType = groupType.asGroupType();
            if (myMapType.getFieldCount() != 1 || ((Type)myMapType.getFields().get(0)).isPrimitive()) {
                return false;
            }
            GroupType mapItemType = ((Type)myMapType.getFields().get(0)).asGroupType();
            return mapItemType.isRepetition(Type.Repetition.REPEATED) && mapItemType.getFieldCount() == 2 && ((Type)mapItemType.getFields().get(0)).getName().equalsIgnoreCase("key") && ((Type)mapItemType.getFields().get(0)).isPrimitive() && ((Type)mapItemType.getFields().get(1)).getName().equalsIgnoreCase("value");
        }
        return false;
    }

    private static Map<String, Object> convertLogicalMap(Group g, boolean binaryAsString) {
        assert (ParquetGroupConverter.isLogicalMapType((Type)g.getType()));
        int mapEntries = g.getFieldRepetitionCount(0);
        HashMap<String, Object> converted = new HashMap<String, Object>();
        for (int i = 0; i < mapEntries; ++i) {
            Group mapEntry = g.getGroup(0, i);
            String key = ParquetGroupConverter.convertPrimitiveField(mapEntry, 0, binaryAsString).toString();
            Object value = ParquetGroupConverter.convertField(mapEntry, "value", binaryAsString);
            converted.put(key, value);
        }
        return converted;
    }

    @Nullable
    private static Object convertPrimitiveField(Group g, int fieldIndex, boolean binaryAsString) {
        PrimitiveType pt = (PrimitiveType)g.getType().getFields().get(fieldIndex);
        if (pt.isRepetition(Type.Repetition.REPEATED) && g.getFieldRepetitionCount(fieldIndex) > 1) {
            ArrayList<Object> vals = new ArrayList<Object>();
            for (int i = 0; i < g.getFieldRepetitionCount(fieldIndex); ++i) {
                vals.add(ParquetGroupConverter.convertPrimitiveField(g, fieldIndex, i, binaryAsString));
            }
            return vals;
        }
        return ParquetGroupConverter.convertPrimitiveField(g, fieldIndex, 0, binaryAsString);
    }

    @Nullable
    private static Object convertPrimitiveField(Group g, int fieldIndex, int index, boolean binaryAsString) {
        PrimitiveType pt = (PrimitiveType)g.getType().getFields().get(fieldIndex);
        OriginalType ot = pt.getOriginalType();
        try {
            if (ot != null) {
                switch (ot) {
                    case DATE: {
                        long ts = (long)g.getInteger(fieldIndex, index) * MILLIS_IN_DAY;
                        return ts;
                    }
                    case TIME_MICROS: {
                        return g.getLong(fieldIndex, index);
                    }
                    case TIME_MILLIS: {
                        return g.getInteger(fieldIndex, index);
                    }
                    case TIMESTAMP_MICROS: {
                        return TimeUnit.MILLISECONDS.convert(g.getLong(fieldIndex, index), TimeUnit.MICROSECONDS);
                    }
                    case TIMESTAMP_MILLIS: {
                        return g.getLong(fieldIndex, index);
                    }
                    case INTERVAL: {
                        Binary intervalVal = g.getBinary(fieldIndex, index);
                        IntBuffer intBuf = intervalVal.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                        int months = intBuf.get(0);
                        int days = intBuf.get(1);
                        int millis = intBuf.get(2);
                        StringBuilder periodBuilder = new StringBuilder("P");
                        if (months > 0) {
                            periodBuilder.append(months).append("M");
                        }
                        if (days > 0) {
                            periodBuilder.append(days).append("D");
                        }
                        if (periodBuilder.length() > 1) {
                            Period p = Period.parse((String)periodBuilder.toString());
                            Duration d = p.toStandardDuration().plus((long)millis);
                            return d;
                        }
                        return new Duration((long)millis);
                    }
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        return g.getInteger(fieldIndex, index);
                    }
                    case INT_64: {
                        return g.getLong(fieldIndex, index);
                    }
                    case UINT_8: 
                    case UINT_16: {
                        return g.getInteger(fieldIndex, index);
                    }
                    case UINT_32: 
                    case UINT_64: {
                        return g.getLong(fieldIndex, index);
                    }
                    case DECIMAL: {
                        int precision = pt.asPrimitiveType().getDecimalMetadata().getPrecision();
                        int scale = pt.asPrimitiveType().getDecimalMetadata().getScale();
                        switch (pt.getPrimitiveTypeName()) {
                            case INT32: {
                                return new BigDecimal(g.getInteger(fieldIndex, index));
                            }
                            case INT64: {
                                return new BigDecimal(g.getLong(fieldIndex, index));
                            }
                            case FIXED_LEN_BYTE_ARRAY: 
                            case BINARY: {
                                Binary value = g.getBinary(fieldIndex, index);
                                return ParquetGroupConverter.convertBinaryToDecimal(value, precision, scale);
                            }
                        }
                        throw new RE("Unknown 'DECIMAL' type supplied to primitive conversion: %s (this should never happen)", new Object[]{pt.getPrimitiveTypeName()});
                    }
                    case UTF8: 
                    case ENUM: 
                    case JSON: {
                        return g.getString(fieldIndex, index);
                    }
                }
                throw new RE("Non-primitive supplied to primitive conversion: %s (this should never happen)", new Object[]{ot.name()});
            }
            switch (pt.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    return g.getBoolean(fieldIndex, index);
                }
                case INT32: {
                    return g.getInteger(fieldIndex, index);
                }
                case INT64: {
                    return g.getLong(fieldIndex, index);
                }
                case FLOAT: {
                    return Float.valueOf(g.getFloat(fieldIndex, index));
                }
                case DOUBLE: {
                    return g.getDouble(fieldIndex, index);
                }
                case INT96: {
                    Binary tsBin = g.getInt96(fieldIndex, index);
                    return ParquetGroupConverter.convertInt96BinaryToTimestamp(tsBin);
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    Binary bin = g.getBinary(fieldIndex, index);
                    byte[] bytes = bin.getBytes();
                    if (binaryAsString) {
                        return StringUtils.fromUtf8((byte[])bytes);
                    }
                    return bytes;
                }
            }
            throw new RE("Unknown primitive conversion: %s", new Object[]{pt.getPrimitiveTypeName()});
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static long convertInt96BinaryToTimestamp(Binary value) {
        byte[] bytes = value.getBytes();
        long timeOfDayNanos = Longs.fromBytes((byte)bytes[7], (byte)bytes[6], (byte)bytes[5], (byte)bytes[4], (byte)bytes[3], (byte)bytes[2], (byte)bytes[1], (byte)bytes[0]);
        int julianDay = Ints.fromBytes((byte)bytes[11], (byte)bytes[10], (byte)bytes[9], (byte)bytes[8]);
        long ts = (long)(julianDay - 2440588) * MILLIS_IN_DAY + timeOfDayNanos / NANOS_PER_MILLISECOND;
        return ts;
    }

    private static BigDecimal convertBinaryToDecimal(Binary value, int precision, int scale) {
        if (precision <= 18) {
            ByteBuffer buffer = value.toByteBuffer();
            byte[] bytes = buffer.array();
            int start = buffer.arrayOffset() + buffer.position();
            int end = buffer.arrayOffset() + buffer.limit();
            long unscaled = 0L;
            for (int i = start; i < end; ++i) {
                unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
            }
            int bits = 8 * (end - start);
            long unscaledNew = unscaled << 64 - bits >> 64 - bits;
            if ((double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                return new BigDecimal(unscaledNew);
            }
            return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
        }
        return new BigDecimal(new BigInteger(value.getBytes()), scale);
    }

    ParquetGroupConverter(boolean binaryAsString) {
        this.binaryAsString = binaryAsString;
    }

    @Nullable
    Object convertField(Group g, String fieldName) {
        return ParquetGroupConverter.convertField(g, fieldName, this.binaryAsString);
    }

    Object unwrapListElement(Object o) {
        if (o instanceof Group) {
            Group g = (Group)o;
            return ParquetGroupConverter.convertListElement(g, this.binaryAsString);
        }
        return o;
    }
}

